/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.rest;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.analytics.UsageMetrics;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/internal/ui")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class UsageMetricsResource
extends ComponentSupport
implements Resource {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final UsageMetrics usageMetrics;

    @Inject
    public UsageMetricsResource(UsageMetrics usageMetrics) {
        this.usageMetrics = Objects.requireNonNull(usageMetrics);
    }

    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @Produces(value={"application/json"})
    @Timed
    @Path(value="/usage-metrics")
    public Response getUsageMetrics() {
        Usage usage = new Usage();
        usage.addToUsage(this.usageMetrics.getMetrics());
        String result = "";
        try {
            result = this.objectMapper.writeValueAsString((Object)usage);
        }
        catch (JsonProcessingException e) {
            this.log.warn("Cannot create json with metrics: {}", (Object)e.toString());
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    private class Usage {
        private List<Object> usage = new LinkedList<Object>();

        private Usage() {
        }

        public List<Object> getUsage() {
            return this.usage;
        }

        public void setUsage(List<Object> usage) {
            this.usage = usage;
        }

        public void addToUsage(Object obj) {
            this.usage.add(obj);
        }
    }
}

