/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.rest;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import com.sonatype.analytics.internal.metrics.Metric;
import com.sonatype.analytics.internal.metrics.MetricStore;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/internal/ui")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class MetricResource
extends ComponentSupport
implements Resource {
    private final AggregatedMetricsStore aggregatedMetricsStore;
    private final MetricStore metricStore;

    @Inject
    public MetricResource(AggregatedMetricsStore aggregatedMetricsStore, MetricStore metricStore) {
        this.aggregatedMetricsStore = (AggregatedMetricsStore)Preconditions.checkNotNull((Object)aggregatedMetricsStore);
        this.metricStore = (MetricStore)Preconditions.checkNotNull((Object)metricStore);
    }

    @GET
    @Timed
    @Path(value="/metric/{name}/daily")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @Produces(value={"application/json"})
    public List<AggregatedMetric> getMetricDaily(@NotNull @PathParam(value="name") String name) {
        OffsetDateTime now = OffsetDateTime.now();
        return this.aggregatedMetricsStore.browse(name, now.minusMonths(1L), now, AnalyticsConstants.AggregationPeriod.day.toString());
    }

    @GET
    @Timed
    @Path(value="/metric/{name}/hourly")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @Produces(value={"application/json"})
    public List<AggregatedMetric> getMetricHourly(@NotNull @PathParam(value="name") String name) {
        OffsetDateTime now = OffsetDateTime.now();
        return this.aggregatedMetricsStore.browse(name, now.minusDays(1L), now, AnalyticsConstants.AggregationPeriod.hour.toString());
    }

    @GET
    @Timed
    @Path(value="/metric/{name}/minute")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:metrics:read"})
    @Produces(value={"application/json"})
    public Collection<Metric> getMetricsForLast30Minutes(@NotNull @PathParam(value="name") String name) {
        OffsetDateTime now = OffsetDateTime.now();
        return this.metricStore.getMetricRecords(name, now.minusMinutes(30L), now);
    }
}

