/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.repository;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.service.CommonQueryDataService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.FormatFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.types.GroupType;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class RepositoryAnalytics
implements AnalyticsMarker {
    private final RepositoryManager repositoryManager;
    private final CommonQueryDataService commonQueryDataService;

    @Inject
    public RepositoryAnalytics(RepositoryManager repositoryManager, CommonQueryDataService commonQueryDataService) {
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
        this.commonQueryDataService = Objects.requireNonNull(commonQueryDataService);
    }

    @CachedGauge(name="nexus.analytics.component_total_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Long componentTotalCount() {
        Iterable repositories = this.repositoryManager.browse();
        return this.countComponents(repositories);
    }

    @CachedGauge(name="nexus.analytics.repository_type_counts", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> countByType() {
        Map<List, Long> countsByFormatAndType = Streams.stream((Iterable)this.repositoryManager.browse()).collect(Collectors.groupingBy(this::listKey, Collectors.counting()));
        return countsByFormatAndType.entrySet().stream().map(entry -> this.toFormatTypeCountMap((String)((List)entry.getKey()).get(0), (String)((List)entry.getKey()).get(1), entry.getValue())).collect(Collectors.toList());
    }

    @CachedGauge(name="nexus.analytics.repository_asset_count_by_format_type", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> assetCountByFormatAndType() {
        Map<List, List<Repository>> repositoriesByFormatAndType = Streams.stream((Iterable)this.repositoryManager.browse()).collect(Collectors.groupingBy(this::listKey));
        return repositoriesByFormatAndType.entrySet().stream().map(entry -> this.toFormatTypeCountMap((String)((List)entry.getKey()).get(0), (String)((List)entry.getKey()).get(1), this.countAssets((List)entry.getValue()))).collect(Collectors.toList());
    }

    @CachedGauge(name="nexus.analytics.repository_component_count_by_format_type", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> componentCountByFormatAndType() {
        Map<List, List<Repository>> repositoriesByFormatAndType = Streams.stream((Iterable)this.repositoryManager.browse()).collect(Collectors.groupingBy(this::listKey));
        return repositoriesByFormatAndType.entrySet().stream().map(entry -> this.toFormatTypeCountMap((String)((List)entry.getKey()).get(0), (String)((List)entry.getKey()).get(1), this.countComponents((Iterable)entry.getValue()))).collect(Collectors.toList());
    }

    @CachedGauge(name="nexus.analytics.docker_v1_api_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Long dockerV1EnabledCount() {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(repository -> {
            NestedAttributesMap dockerAttributes = repository.getConfiguration().attributes("docker");
            return dockerAttributes.contains("v1Enabled") && Objects.equals(dockerAttributes.get("v1Enabled"), true);
        }).count();
    }

    @CachedGauge(name="nexus.analytics.group_write_configured_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long groupWriteConfiguredCount() {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(this::groupWriteMemberExists).count();
    }

    @CachedGauge(name="nexus.analytics.group_write_configured_per_format_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> groupWriteConfiguredPerFormatCount() {
        Map<String, Long> collect = Streams.stream((Iterable)this.repositoryManager.browse()).filter(repository -> repository.getType() instanceof GroupType).filter(this::groupWriteMemberExists).collect(Collectors.groupingBy(s -> s.getFormat().toString(), Collectors.counting()));
        return collect.entrySet().stream().map(entry -> this.toFormatCountMap((String)entry.getKey(), (Long)entry.getValue())).collect(Collectors.toList());
    }

    private boolean groupWriteMemberExists(Repository repository) {
        NestedAttributesMap groupAttributes = repository.getConfiguration().attributes("group");
        String groupWriteMember = (String)groupAttributes.get("groupWriteMember");
        return groupWriteMember != null && this.repositoryManager.exists(groupWriteMember);
    }

    private Map<String, Object> toFormatTypeCountMap(String formatValue, String typeValue, Object count) {
        return ImmutableMap.of((Object)"format", (Object)formatValue, (Object)"type", (Object)typeValue, (Object)"count", (Object)count);
    }

    private Map<String, Object> toFormatCountMap(String formatValue, Long count) {
        return ImmutableMap.of((Object)"format", (Object)formatValue, (Object)"count", (Object)count);
    }

    private long countAssets(List<Repository> repositories) {
        return this.commonQueryDataService.getAssetCount(repositories);
    }

    private long countComponents(Iterable<Repository> repositories) {
        return this.commonQueryDataService.getComponentCount(repositories);
    }

    private List<String> listKey(Repository repository) {
        Optional formatFacet = repository.optionalFacet(FormatFacet.class);
        String format = repository.getFormat().getValue();
        if (formatFacet.isPresent() && ((FormatFacet)formatFacet.get()).getSubFormat() != null) {
            format = String.valueOf(format) + ((FormatFacet)formatFacet.get()).getSubFormat();
        }
        return Arrays.asList(format, repository.getType().getValue());
    }
}

