/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.realms;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.security.realm.RealmManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class SecurityRealmAnalytics
implements AnalyticsMarker {
    private final RealmManager realmManager;

    @Inject
    public SecurityRealmAnalytics(RealmManager realmManager) {
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
    }

    @CachedGauge(name="nexus.analytics.security_realms", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<String> getActiveRealms() {
        return this.realmManager.getConfiguredRealmIds(true);
    }
}

