/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.orient;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.analytics.internal.metrics.Metric;
import com.sonatype.analytics.internal.metrics.MetricStore;
import com.sonatype.analytics.internal.metrics.orient.MetricEntityAdapter;
import com.sonatype.analytics.internal.metrics.orient.OrientMetric;
import java.time.OffsetDateTime;
import java.util.Collection;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientMetricStore
extends StateGuardLifecycleSupport
implements MetricStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final MetricEntityAdapter entityAdapter;
    private final NodeAccess nodeAccess;

    @Inject
    public OrientMetricStore(@Named(value="analytics") @Named(value="analytics") Provider<DatabaseInstance> databaseInstance, MetricEntityAdapter entityAdapter, NodeAccess nodeAccess) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (MetricEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    @Timed
    public Long getMaxMetricValue(String metricName, OffsetDateTime start, OffsetDateTime end) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getMaxMetricValue(db, metricName, start, end));
    }

    @Override
    @Guarded(by={"STARTED"})
    @Timed
    public Long getSumMetricValue(String metricName, OffsetDateTime start, OffsetDateTime end) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getSumMetricValue(db, metricName, start, end));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Collection<Metric> getMetricRecords(String metricName, OffsetDateTime start, OffsetDateTime end) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        return (Collection)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getRecords(db, metricName, start, end));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void addMetricData(String metricName, long metricValue, OffsetDateTime metricDate) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)metricDate);
        OrientMetric entity = this.entityAdapter.newEntity();
        entity.setMetricName(metricName);
        entity.setMetricValue(metricValue);
        entity.setTimestamp(metricDate);
        entity.setNodeId(this.nodeAccess.getId());
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)entity);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void deleteBeforeDate(String metricName, OffsetDateTime cutoff) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)cutoff);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteBefore(db, metricName, cutoff));
    }
}

