/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.orient;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.sonatype.analytics.internal.metrics.HistoricalLoginInfo;
import com.sonatype.analytics.internal.metrics.HistoricalLoginInfoStore;
import com.sonatype.analytics.internal.metrics.orient.HistoricalLoginInfoEntity;
import com.sonatype.analytics.internal.metrics.orient.HistoricalLoginInfoEntityAdapter;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Priority(value=0x7FFFFFFF)
@Named(value="orient")
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class OrientHistoricalLoginInfoStore
extends StateGuardLifecycleSupport
implements HistoricalLoginInfoStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final HistoricalLoginInfoEntityAdapter entityAdapter;

    @Inject
    public OrientHistoricalLoginInfoStore(@Named(value="analytics") @Named(value="analytics") Provider<DatabaseInstance> databaseInstance, HistoricalLoginInfoEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (HistoricalLoginInfoEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public Collection<HistoricalLoginInfo> browse() {
        return (Collection)OrientTransactional.inTx(this.databaseInstance).call(db -> StreamSupport.stream(this.entityAdapter.browse(db).spliterator(), false).collect(Collectors.toList()));
    }

    @Override
    @Guarded(by={"STARTED"})
    public HistoricalLoginInfo save(String username, String realm, OffsetDateTime timestamp) {
        HistoricalLoginInfoEntity entity = this.entityAdapter.newEntity();
        entity.setUsername(username);
        entity.setRealm(realm);
        entity.setLoginDate(timestamp);
        return (HistoricalLoginInfo)OrientTransactional.inTxRetry(this.databaseInstance).call(db -> (HistoricalLoginInfoEntity)this.entityAdapter.readEntity((OIdentifiable)this.entityAdapter.addEntity(db, (Entity)entity)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void save(List<HistoricalLoginInfo> loginInfos) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> loginInfos.forEach(info -> {
            HistoricalLoginInfoEntity entity = this.entityAdapter.newEntity();
            entity.setUsername(info.getUsername());
            entity.setRealm(info.getRealm());
            entity.setLoginDate(info.getLoginDate());
            this.entityAdapter.addEntity(db, (Entity)entity);
        }));
    }

    @Override
    @Guarded(by={"STARTED"})
    @Timed
    public long getUniqueLoginsCountForPeriod(OffsetDateTime startDate, OffsetDateTime endDate) {
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getUniqueLogins(db, startDate, endDate));
    }

    @Override
    @Guarded(by={"STARTED"})
    @Timed
    public Collection<HistoricalLoginInfo> getUniqueLoginsSince(OffsetDateTime startDate) {
        return (Collection)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getUniqueLoginsSince(db, startDate));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void deleteEntitiesBeforeDate(OffsetDateTime date) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> this.entityAdapter.deleteEntitiesBeforeDate(db, date));
    }
}

