/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.orient;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import com.sonatype.analytics.internal.metrics.orient.OrientAggregatedMetric;
import com.sonatype.analytics.internal.metrics.orient.OrientAggregatedMetricsEntityAdapter;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientAggregatedMetricsStore
extends StateGuardLifecycleSupport
implements AggregatedMetricsStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientAggregatedMetricsEntityAdapter entityAdapter;

    @Inject
    public OrientAggregatedMetricsStore(@Named(value="analytics") @Named(value="analytics") Provider<DatabaseInstance> databaseInstance, OrientAggregatedMetricsEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientAggregatedMetricsEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Long getLastValue(String name, AnalyticsConstants.AggregationPeriod period) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)period));
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getLastValue(db, name, period.toString()));
    }

    @Override
    @Guarded(by={"STARTED"})
    @Timed
    public Long getMaxMetricValue(String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)periodType);
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getMaxMetricValue(db, name, start, end, periodType));
    }

    @Override
    @Guarded(by={"STARTED"})
    @Timed
    public Long getSumMetricValue(String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)periodType);
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getSumMetricValue(db, name, start, end, periodType));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<AggregatedMetric> browse(String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)periodType);
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getRecords(db, name, start, end, periodType));
    }

    @Override
    @Guarded(by={"STARTED"})
    public void addMetricData(String name, Long value, OffsetDateTime metricDate, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)metricDate);
        Preconditions.checkNotNull((Object)periodType);
        OrientAggregatedMetric entity = this.entityAdapter.newEntity();
        entity.setMetricName(name);
        entity.setMetricValue(value);
        entity.setPeriodType(periodType);
        entity.setMetricDate(metricDate);
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)entity);
        });
    }

    @Override
    public Collection<AggregatedMetric> getRecordsSince(OffsetDateTime start) {
        Preconditions.checkNotNull((Object)start);
        return (Collection)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.getRecords(db, start));
    }
}

