/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.orient;

import com.google.common.collect.ImmutableMap;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.orient.OrientAggregatedMetric;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class OrientAggregatedMetricsEntityAdapter
extends IterableEntityAdapter<OrientAggregatedMetric> {
    private static final String DB_CLASS = new OClassNameBuilder().type("aggregated_metric").build();
    private static final String P_METRIC_NAME = "metric_name";
    private static final String P_METRIC_VALUE = "metric_value";
    private static final String P_METRIC_DATE = "metric_date";
    private static final String P_PERIOD_TYPE = "period_type";
    private static final String P_PERIOD_START = "period_start";
    private static final String P_PERIOD_END = "period_end";
    private static final String I_METRIC_DATA = new OIndexNameBuilder().type(DB_CLASS).property("metric_name").property("period_type").property("metric_date").build();
    private static final String QUERY_FETCH_RECORDS_SINCE = String.format("SELECT FROM %s WHERE %s >= :period_start", DB_CLASS, "metric_date");
    private static final String QUERY_FETCH_RECORDS = String.format("SELECT FROM %s WHERE %s = :metric_name AND %s = :period_type AND %s >= :period_start AND %s < :period_end", DB_CLASS, "metric_name", "period_type", "metric_date", "metric_date");
    private static final String QUERY_LAST_METRIC_VALUE = String.format("SELECT * FROM %s WHERE %s = :metric_name AND %s = :period_type ORDER BY %s DESC LIMIT 1;", DB_CLASS, "metric_name", "period_type", "metric_date");
    private static final String QUERY_SUM_METRIC_VALUE = String.format("SELECT SUM(metric_value) FROM %s WHERE %s = :metric_name AND %s = :period_type AND %s >= :period_start AND %s < :period_end", DB_CLASS, "metric_name", "period_type", "metric_date", "metric_date");
    private static final String QUERY_MAX_VALUE = String.format("SELECT MAX(metric_value) FROM %s WHERE %s = :metric_name AND %s = :period_type AND %s >= :period_start AND %s < :period_end", DB_CLASS, "metric_name", "period_type", "metric_date", "metric_date");

    @Inject
    public OrientAggregatedMetricsEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_METRIC_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_METRIC_VALUE, OType.LONG).setMandatory(true).setNotNull(true);
        type.createProperty(P_PERIOD_TYPE, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_METRIC_DATE, OType.LONG).setMandatory(true).setNotNull(true);
        type.createIndex(I_METRIC_DATA, OClass.INDEX_TYPE.UNIQUE, new String[]{P_METRIC_NAME, P_PERIOD_TYPE, P_METRIC_DATE});
    }

    protected OrientAggregatedMetric newEntity() {
        return new OrientAggregatedMetric();
    }

    protected void readFields(ODocument document, OrientAggregatedMetric entity) throws Exception {
        String metricName = (String)document.field(P_METRIC_NAME, OType.STRING);
        Long metricData = (Long)document.field(P_METRIC_VALUE, OType.LONG);
        String periodType = (String)document.field(P_PERIOD_TYPE, OType.STRING);
        entity.setMetricName(metricName);
        entity.setMetricValue(metricData);
        entity.setPeriodType(periodType);
        Long metricDate = (Long)document.field(P_METRIC_DATE, OType.LONG);
        OffsetDateTime timestamp = OffsetDateTime.ofInstant(Instant.ofEpochMilli(metricDate), ZoneOffset.UTC);
        entity.setMetricDate(timestamp);
    }

    protected void writeFields(ODocument document, OrientAggregatedMetric entity) {
        document.field(P_METRIC_NAME, (Object)entity.getMetricName());
        document.field(P_METRIC_VALUE, (Object)entity.getMetricValue());
        document.field(P_PERIOD_TYPE, (Object)entity.getPeriodType());
        document.field(P_METRIC_DATE, (Object)entity.getMetricDate().toInstant().toEpochMilli());
    }

    public Long getLastValue(ODatabaseDocumentTx db, String name, String periodType) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)name, (Object)P_PERIOD_TYPE, (Object)periodType);
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(QUERY_LAST_METRIC_VALUE)).execute(new Object[]{params});
        if (result != null) {
            return result.stream().map(arg_0 -> ((OrientAggregatedMetricsEntityAdapter)this).readEntity(arg_0)).map(AggregatedMetric::getMetricValue).findFirst().orElse(null);
        }
        return null;
    }

    public List<AggregatedMetric> getRecords(ODatabaseDocumentTx db, String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)name, (Object)P_PERIOD_TYPE, (Object)periodType, (Object)P_PERIOD_START, (Object)start.toInstant().toEpochMilli(), (Object)P_PERIOD_END, (Object)end.toInstant().toEpochMilli());
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(QUERY_FETCH_RECORDS)).execute(new Object[]{params});
        if (result != null) {
            return result.stream().map(arg_0 -> ((OrientAggregatedMetricsEntityAdapter)this).readEntity(arg_0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Long getSumMetricValue(ODatabaseDocumentTx db, String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)name, (Object)P_PERIOD_TYPE, (Object)periodType, (Object)P_PERIOD_START, (Object)start.toInstant().toEpochMilli(), (Object)P_PERIOD_END, (Object)end.toInstant().toEpochMilli());
        List results = (List)db.command((OCommandRequest)new OCommandSQL(QUERY_SUM_METRIC_VALUE)).execute(new Object[]{params});
        Long sum = (Long)((ODocument)results.get(0)).field("SUM", Long.class);
        return sum != null ? sum : 0L;
    }

    public Long getMaxMetricValue(ODatabaseDocumentTx db, String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)name, (Object)P_PERIOD_TYPE, (Object)periodType, (Object)P_PERIOD_START, (Object)start.toInstant().toEpochMilli(), (Object)P_PERIOD_END, (Object)end.toInstant().toEpochMilli());
        List results = (List)db.command((OCommandRequest)new OCommandSQL(QUERY_MAX_VALUE)).execute(new Object[]{params});
        Long max = (Long)((ODocument)results.get(0)).field("MAX", Long.class);
        return max != null ? max : 0L;
    }

    public List<AggregatedMetric> getRecords(ODatabaseDocumentTx db, OffsetDateTime start) {
        ImmutableMap params = ImmutableMap.of((Object)P_PERIOD_START, (Object)start.toInstant().toEpochMilli());
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(QUERY_FETCH_RECORDS_SINCE)).execute(new Object[]{params});
        if (result != null) {
            return result.stream().map(arg_0 -> ((OrientAggregatedMetricsEntityAdapter)this).readEntity(arg_0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

