/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.orient;

import com.google.common.collect.ImmutableMap;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.analytics.internal.metrics.Metric;
import com.sonatype.analytics.internal.metrics.orient.OrientMetric;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class MetricEntityAdapter
extends IterableEntityAdapter<OrientMetric> {
    public static final String DB_NAME = "metrics_log";
    private static final String DB_CLASS = new OClassNameBuilder().type("metrics_log").build();
    private static final String P_METRIC_NAME = "metric_name";
    private static final String P_TIMESTAMP = "timestamp";
    private static final String P_NODE_ID = "node_id";
    private static final String P_METRIC_VALUE = "metric_value";
    private static final String P_START = "start";
    private static final String P_END = "end";
    private static final String I_METRIC_DATA = new OIndexNameBuilder().type(DB_CLASS).property("metric_name").property("timestamp").build();
    private static final String QUERY_RECORDS_FOR_PERIOD = String.format("SELECT FROM %s WHERE %s = :metric_name AND %s >= :start AND %s < :end", DB_CLASS, "metric_name", "timestamp", "timestamp");
    private static final String QUERY_SUM_METRIC_VALUE = String.format("SELECT SUM(metric_value) FROM %s WHERE %s = :metric_name AND %s >= :start AND %s < :end", DB_CLASS, "metric_name", "timestamp", "timestamp");
    private static final String QUERY_MAX_VALUE = String.format("SELECT MAX(metric_value) FROM %s WHERE %s = :metric_name AND %s >= :start AND %s < :end", DB_CLASS, "metric_name", "timestamp", "timestamp");
    private static final String QUERY_DELETE_RECORDS_BEFORE = String.format("DELETE FROM %s WHERE %s = :metric_name AND %s < :end LIMIT 500", DB_CLASS, "metric_name", "timestamp");

    public MetricEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_METRIC_NAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_NODE_ID, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_TIMESTAMP, OType.LONG).setMandatory(true).setNotNull(true);
        type.createProperty(P_METRIC_VALUE, OType.LONG).setMandatory(true).setNotNull(true);
        type.createIndex(I_METRIC_DATA, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_METRIC_NAME, P_TIMESTAMP});
    }

    protected OrientMetric newEntity() {
        return new OrientMetric();
    }

    protected void readFields(ODocument document, OrientMetric entity) throws Exception {
        entity.setMetricName((String)document.field(P_METRIC_NAME, OType.STRING));
        entity.setNodeId((String)document.field(P_NODE_ID, OType.STRING));
        entity.setMetricValue((Long)document.field(P_METRIC_VALUE, OType.LONG));
        Long metricDate = (Long)document.field(P_TIMESTAMP, OType.LONG);
        OffsetDateTime timestamp = OffsetDateTime.ofInstant(Instant.ofEpochMilli(metricDate), ZoneOffset.UTC);
        entity.setTimestamp(timestamp);
    }

    protected void writeFields(ODocument document, OrientMetric entity) throws Exception {
        document.field(P_METRIC_NAME, (Object)entity.getMetricName());
        document.field(P_NODE_ID, (Object)entity.getNodeId());
        document.field(P_METRIC_VALUE, (Object)entity.getMetricValue());
        document.field(P_TIMESTAMP, (Object)entity.getTimestamp().toInstant().toEpochMilli());
    }

    public Collection<Metric> getRecords(ODatabaseDocumentTx db, String metricName, OffsetDateTime start, OffsetDateTime end) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)metricName, (Object)P_START, (Object)start.toInstant().toEpochMilli(), (Object)P_END, (Object)end.toInstant().toEpochMilli());
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(QUERY_RECORDS_FOR_PERIOD)).execute(new Object[]{params});
        if (result != null) {
            return result.stream().map(arg_0 -> ((MetricEntityAdapter)this).readEntity(arg_0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Long getSumMetricValue(ODatabaseDocumentTx db, String name, OffsetDateTime start, OffsetDateTime end) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)name, (Object)P_START, (Object)start.toInstant().toEpochMilli(), (Object)P_END, (Object)end.toInstant().toEpochMilli());
        List results = (List)db.command((OCommandRequest)new OCommandSQL(QUERY_SUM_METRIC_VALUE)).execute(new Object[]{params});
        Long sum = (Long)((ODocument)results.get(0)).field("SUM", Long.class);
        return sum != null ? sum : 0L;
    }

    public Long getMaxMetricValue(ODatabaseDocumentTx db, String metricName, OffsetDateTime start, OffsetDateTime end) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)metricName, (Object)P_START, (Object)start.toInstant().toEpochMilli(), (Object)P_END, (Object)end.toInstant().toEpochMilli());
        List results = (List)db.command((OCommandRequest)new OCommandSQL(QUERY_MAX_VALUE)).execute(new Object[]{params});
        Long max = (Long)((ODocument)results.get(0)).field("MAX", Long.class);
        return max != null ? max : 0L;
    }

    public void deleteBefore(ODatabaseDocumentTx db, String metricName, OffsetDateTime cutoff) {
        ImmutableMap params = ImmutableMap.of((Object)P_METRIC_NAME, (Object)metricName, (Object)P_END, (Object)cutoff.toInstant().toEpochMilli());
        db.command((OCommandRequest)new OCommandSQL(QUERY_DELETE_RECORDS_BEFORE)).execute(new Object[]{params});
    }
}

