/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.orient;

import com.google.common.collect.ImmutableMap;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.analytics.internal.metrics.HistoricalLoginInfo;
import com.sonatype.analytics.internal.metrics.orient.HistoricalLoginInfoEntity;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class HistoricalLoginInfoEntityAdapter
extends IterableEntityAdapter<HistoricalLoginInfoEntity> {
    private static final String DB_CLASS = new OClassNameBuilder().type("historical_login_info").build();
    public static final String P_USERNAME = "username";
    public static final String P_REALM = "realm";
    public static final String P_LOGIN_DATE = "login_date";
    private static final String PERIOD_START = "period_start";
    private static final String PERIOD_END = "period_end";
    private static final String I_USERNAME_REALM_LOGINDATE = new OIndexNameBuilder().type(DB_CLASS).property("login_date").property("username").property("realm").build();
    private static final String QUERY_DELETE_BEFORE_DATE = String.format("DELETE FROM %s WHERE %s < :period_end", DB_CLASS, "login_date");
    private static final String QUERY_GET_LOGINS_SINCE_DATE = String.format("SELECT username, realm, MAX(login_date) as login_date FROM %s WHERE %s >= :period_start GROUP BY %s, %s", DB_CLASS, "login_date", "username", "realm");
    private static final String QUERY_COUNT_UNIQUE = String.format("SELECT DISTINCT(%s) FROM %s WHERE %s >= :period_start AND %s < :period_end GROUP BY %s", "realm", DB_CLASS, "login_date", "login_date", "username");

    public HistoricalLoginInfoEntityAdapter() {
        super(DB_CLASS);
    }

    public void deleteEntitiesBeforeDate(ODatabaseDocumentTx db, OffsetDateTime date) {
        ImmutableMap params = ImmutableMap.of((Object)PERIOD_END, (Object)date.toInstant().toEpochMilli());
        db.command((OCommandRequest)new OCommandSQL(QUERY_DELETE_BEFORE_DATE)).execute(new Object[]{params});
    }

    public Collection<HistoricalLoginInfo> getUniqueLoginsSince(ODatabaseDocumentTx db, OffsetDateTime startDate) {
        ImmutableMap params = ImmutableMap.of((Object)PERIOD_START, (Object)startDate.toInstant().toEpochMilli());
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(QUERY_GET_LOGINS_SINCE_DATE)).execute(new Object[]{params});
        if (result != null) {
            return result.stream().map(arg_0 -> ((HistoricalLoginInfoEntityAdapter)this).readEntity(arg_0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected void defineType(OClass type) {
        type.createProperty(P_USERNAME, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_REALM, OType.STRING).setMandatory(true).setNotNull(true);
        type.createProperty(P_LOGIN_DATE, OType.LONG).setMandatory(true).setNotNull(true);
        type.createIndex(I_USERNAME_REALM_LOGINDATE, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_USERNAME, P_REALM, P_LOGIN_DATE});
    }

    protected HistoricalLoginInfoEntity newEntity() {
        return new HistoricalLoginInfoEntity();
    }

    protected void readFields(ODocument document, HistoricalLoginInfoEntity entity) {
        entity.setUsername((String)document.field(P_USERNAME, OType.STRING));
        entity.setRealm((String)document.field(P_REALM, OType.STRING));
        Long metricDate = (Long)document.field(P_LOGIN_DATE, OType.LONG);
        OffsetDateTime timestamp = OffsetDateTime.ofInstant(Instant.ofEpochMilli(metricDate), ZoneOffset.UTC);
        entity.setLoginDate(timestamp);
    }

    protected void writeFields(ODocument document, HistoricalLoginInfoEntity entity) {
        document.field(P_USERNAME, (Object)entity.getUsername());
        document.field(P_REALM, (Object)entity.getRealm());
        document.field(P_LOGIN_DATE, (Object)entity.getLoginDate().toInstant().toEpochMilli());
    }

    public long getUniqueLogins(ODatabaseDocumentTx db, OffsetDateTime start, OffsetDateTime end) {
        ImmutableMap params = ImmutableMap.of((Object)PERIOD_START, (Object)start.toInstant().toEpochMilli(), (Object)PERIOD_END, (Object)end.toInstant().toEpochMilli());
        List result = (List)db.command((OCommandRequest)new OSQLSynchQuery(QUERY_COUNT_UNIQUE)).execute(new Object[]{params});
        if (result != null) {
            return result.size();
        }
        return 0L;
    }
}

