/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.datastore;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.metrics.HistoricalLoginInfo;
import com.sonatype.analytics.internal.metrics.HistoricalLoginInfoStore;
import com.sonatype.analytics.internal.metrics.datastore.HistoricalLoginInfoDAO;
import com.sonatype.analytics.internal.metrics.datastore.HistoricalLoginInfoData;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class HistoricalLoginInfoStoreImpl
extends ContentStoreSupport<HistoricalLoginInfoDAO>
implements HistoricalLoginInfoStore {
    @Inject
    public HistoricalLoginInfoStoreImpl(DataSessionSupplier dataSessionSupplier) {
        super(dataSessionSupplier, "nexus", HistoricalLoginInfoDAO.class);
    }

    @Override
    @Transactional
    public Collection<HistoricalLoginInfo> browse() {
        return ((HistoricalLoginInfoDAO)this.dao()).browse().stream().map(HistoricalLoginInfo.class::cast).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public HistoricalLoginInfo save(String username, String realm, OffsetDateTime timestamp) {
        Preconditions.checkNotNull((Object)username);
        Preconditions.checkNotNull((Object)realm);
        Preconditions.checkNotNull((Object)timestamp);
        HistoricalLoginInfoData loginData = new HistoricalLoginInfoData();
        loginData.setLoginDate(timestamp);
        loginData.setRealm(realm);
        loginData.setUsername(username);
        ((HistoricalLoginInfoDAO)this.dao()).save(loginData);
        return loginData;
    }

    @Override
    @Transactional
    public void save(List<HistoricalLoginInfo> loginsData) {
        Preconditions.checkNotNull(loginsData);
        if (loginsData.isEmpty()) {
            return;
        }
        ((HistoricalLoginInfoDAO)this.dao()).saveBatch(loginsData);
    }

    @Override
    @Timed
    @Transactional
    public long getUniqueLoginsCountForPeriod(OffsetDateTime startDate, OffsetDateTime endDate) {
        Preconditions.checkNotNull((Object)startDate);
        Preconditions.checkNotNull((Object)endDate);
        return ((HistoricalLoginInfoDAO)this.dao()).getUniqueLoginsCountForPeriod(startDate, endDate);
    }

    @Override
    @Timed
    @Transactional
    public Collection<HistoricalLoginInfo> getUniqueLoginsSince(OffsetDateTime startDate) {
        Preconditions.checkNotNull((Object)startDate);
        return ((HistoricalLoginInfoDAO)this.dao()).getUniqueLoginsSince(startDate);
    }

    @Override
    @Timed
    @Transactional
    public void deleteEntitiesBeforeDate(OffsetDateTime periodEnd) {
        Preconditions.checkNotNull((Object)periodEnd);
        ((HistoricalLoginInfoDAO)this.dao()).deleteEntitiesBeforeDate(periodEnd);
    }
}

