/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.datastore;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.repository.Format;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class DataStoreAnalytics
extends ComponentSupport
implements AnalyticsMarker {
    @VisibleForTesting
    static final Collection<String> FORMAT_SPECIFIC_TABLES = Arrays.asList("_asset", "_asset_blob", "_component");
    @VisibleForTesting
    static final Collection<String> TABLES = Arrays.asList("search_components");
    private final DataStoreManager dataStoreManager;
    private final List<String> tableNames;

    @Inject
    public DataStoreAnalytics(DataStoreManager dataStoreManager, List<Format> formats) {
        this.dataStoreManager = (DataStoreManager)Preconditions.checkNotNull((Object)dataStoreManager);
        this.tableNames = Stream.concat(TABLES.stream(), ((List)Preconditions.checkNotNull(formats)).stream().map(Format::getValue).flatMap(format -> FORMAT_SPECIFIC_TABLES.stream().map(suffix -> String.valueOf(format) + suffix))).collect(Collectors.toList());
    }

    @CachedGauge(name="nexus.analytics.data_store", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> metricsByDbType() {
        return StreamSupport.stream(this.dataStoreManager.browse().spliterator(), false).flatMap(this::getDbAnalyticsEntity).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Stream<Map.Entry<String, Object>> getDbAnalyticsEntity(DataStore<?> dataStore) {
        Map<Object, Object> tableSizes;
        String databaseProductVersion;
        String databaseProductName;
        DataStoreConfiguration configuration;
        block20: {
            configuration = dataStore.getConfiguration();
            databaseProductVersion = databaseProductName = "";
            tableSizes = Collections.emptyMap();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (Connection connection = dataStore.getDataSource().getConnection();){
                    DatabaseMetaData metaData = connection.getMetaData();
                    databaseProductName = metaData.getDatabaseProductName();
                    databaseProductVersion = String.valueOf(metaData.getDatabaseMajorVersion()) + "." + metaData.getDatabaseMinorVersion();
                    if (!"PostgreSQL".equals(databaseProductName)) break block20;
                    Throwable throwable2 = null;
                    Object var11_15 = null;
                    try (PreparedStatement statement = connection.prepareStatement("SELECT pg_relation_size(?)");){
                        tableSizes = this.tableNames.stream().collect(Collectors.toMap(Function.identity(), this.createSizeFunction(statement)));
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                this.log.error("Can't collect data store analytics", (Throwable)e);
            }
        }
        return Stream.of(new AbstractMap.SimpleEntry<String, String>(configuration.getName(), databaseProductName), new AbstractMap.SimpleEntry<String, String>(String.valueOf(configuration.getName()) + "_db_version", databaseProductVersion), new AbstractMap.SimpleEntry(String.valueOf(configuration.getName()) + "_table_sizes", tableSizes));
    }

    private Function<String, Long> createSizeFunction(PreparedStatement statement) {
        return tableName -> {
            try {
                statement.setString(1, (String)tableName);
                statement.execute();
                ResultSet results = statement.getResultSet();
                if (results == null || !results.next()) {
                    return -1L;
                }
                return results.getLong(1);
            }
            catch (SQLException e) {
                this.log.debug("Unable to compute table size for {}", tableName, (Object)e);
                return -1L;
            }
        };
    }
}

