/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.datastore;

import com.codahale.metrics.MetricRegistry;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.content.event.component.ComponentCreatedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentDeletedEvent;
import org.sonatype.nexus.repository.content.event.component.ComponentPurgedEvent;
import org.sonatype.nexus.repository.content.event.component.RepositoryDeletedComponentEvent;

@Named
@Singleton
public class ContentUsageMetricListener
implements EventAware {
    private final MetricRegistry metricRegistry;

    @Inject
    public ContentUsageMetricListener(@Named(value="usage") @Named(value="usage") MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        metricRegistry.counter("component_total_count").inc(0L);
    }

    @Subscribe
    @AllowConcurrentEvents
    void on(ComponentCreatedEvent ignored) {
        this.metricRegistry.counter("component_total_count").inc();
    }

    @Subscribe
    @AllowConcurrentEvents
    void on(ComponentDeletedEvent ignored) {
        this.metricRegistry.counter("component_total_count").dec();
    }

    @Subscribe
    @AllowConcurrentEvents
    void on(ComponentPurgedEvent event) {
        this.metricRegistry.counter("component_total_count").dec((long)event.getComponentIds().length);
    }

    @Subscribe
    @AllowConcurrentEvents
    void on(RepositoryDeletedComponentEvent event) {
        this.metricRegistry.counter("component_total_count").dec((long)event.getDeletedComponentsAmount());
    }
}

