/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.datastore;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.metrics.Metric;
import com.sonatype.analytics.internal.metrics.MetricStore;
import com.sonatype.analytics.internal.metrics.datastore.MetricDAO;
import com.sonatype.analytics.internal.metrics.datastore.MetricData;
import java.time.OffsetDateTime;
import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class ContentMetricStore
extends ContentStoreSupport<MetricDAO>
implements MetricStore {
    private final NodeAccess nodeAccess;

    @Inject
    public ContentMetricStore(DataSessionSupplier dataSessionSupplier, NodeAccess nodeAccess) {
        super(dataSessionSupplier, "nexus", MetricDAO.class);
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
    }

    @Override
    @Transactional
    public Collection<Metric> getMetricRecords(String metricName, OffsetDateTime start, OffsetDateTime end) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        return ((MetricDAO)this.dao()).browse(metricName, start, end);
    }

    @Override
    @Transactional
    @Timed
    public Long getSumMetricValue(String metricName, OffsetDateTime start, OffsetDateTime end) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Long sum = ((MetricDAO)this.dao()).getSumMetricValue(metricName, start, end);
        return sum != null ? sum : 0L;
    }

    @Override
    @Transactional
    @Timed
    public Long getMaxMetricValue(String metricName, OffsetDateTime start, OffsetDateTime end) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Long max = ((MetricDAO)this.dao()).getMaxMetricValue(metricName, start, end);
        return max != null ? max : 0L;
    }

    @Override
    @Transactional
    public void addMetricData(String metricName, long metricValue, OffsetDateTime metricDate) {
        Preconditions.checkNotNull((Object)metricName);
        Preconditions.checkNotNull((Object)metricDate);
        MetricData metricData = new MetricData(metricName, metricValue, metricDate, this.nodeAccess.getId());
        ((MetricDAO)this.dao()).save(metricData);
    }

    @Override
    @Transactional
    public void deleteBeforeDate(String metricName, OffsetDateTime cutoff) {
        ((MetricDAO)this.dao()).deleteBeforeDate(metricName, cutoff);
    }
}

