/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics.datastore;

import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import com.sonatype.analytics.internal.metrics.datastore.AggregatedMetricData;
import com.sonatype.analytics.internal.metrics.datastore.AggregatedMetricsDAO;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.repository.content.store.ContentStoreSupport;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class AggregatedMetricsStoreImpl
extends ContentStoreSupport<AggregatedMetricsDAO>
implements AggregatedMetricsStore {
    @Inject
    public AggregatedMetricsStoreImpl(DataSessionSupplier dataSessionSupplier) {
        super(dataSessionSupplier, "nexus", AggregatedMetricsDAO.class);
    }

    @Override
    @Transactional
    @Timed
    public Long getMaxMetricValue(String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)periodType);
        Long max = ((AggregatedMetricsDAO)this.dao()).getMaxMetricValue(name, start, end, periodType);
        return max != null ? max : 0L;
    }

    @Override
    @Transactional
    @Timed
    public Long getSumMetricValue(String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)periodType);
        Long sum = ((AggregatedMetricsDAO)this.dao()).getSumMetricValue(name, start, end, periodType);
        return sum != null ? sum : 0L;
    }

    @Override
    @Transactional
    public List<AggregatedMetric> browse(String name, OffsetDateTime start, OffsetDateTime end, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)start);
        Preconditions.checkNotNull((Object)end);
        Preconditions.checkNotNull((Object)periodType);
        return ((AggregatedMetricsDAO)this.dao()).browse(name, start, end, periodType);
    }

    @Override
    @Transactional
    public void addMetricData(String name, Long value, OffsetDateTime metricDate, String periodType) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull((Object)metricDate);
        Preconditions.checkNotNull((Object)periodType);
        AggregatedMetricData metricData = new AggregatedMetricData(name, value, metricDate, periodType);
        ((AggregatedMetricsDAO)this.dao()).save(metricData);
    }

    @Override
    @Transactional
    public Collection<AggregatedMetric> getRecordsSince(OffsetDateTime start) {
        return ((AggregatedMetricsDAO)this.dao()).getRecordsSince(start);
    }

    @Override
    @Transactional
    public Long getLastValue(String name, AnalyticsConstants.AggregationPeriod period) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)period));
        return ((AggregatedMetricsDAO)this.dao()).getLastValue(name, period.toString());
    }
}

