/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.analytics.UsageMetrics;

@Named
@Singleton
public class UsageMetricsImpl
extends ComponentSupport
implements UsageMetrics {
    private static final String UNIQUE_USERS_LAST_30_D_KEY = "unique_users_last_30d";
    private static final String REQUEST_RATES_KEY = "request_rates";
    private static final String SUCCESSFUL_LAST_30_D_METRIC = "successful_last_30d";
    private static final String DATE = "date";
    private static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    private final MetricRegistry analyticsRegistry;
    private final MetricRegistry usageRegistry;
    private final AggregatedMetricsStore aggregatedMetricsStore;

    @Inject
    public UsageMetricsImpl(MetricRegistry analyticsRegistry, @Named(value="usage") @Named(value="usage") MetricRegistry usageRegistry, AggregatedMetricsStore aggregatedMetricsStore) {
        this.analyticsRegistry = Objects.requireNonNull(analyticsRegistry);
        this.usageRegistry = Objects.requireNonNull(usageRegistry);
        this.aggregatedMetricsStore = Objects.requireNonNull(aggregatedMetricsStore);
    }

    public Map<String, Object> getMetrics() {
        Gauge requestCountsGauge;
        Long aggregatedComponentsCount;
        Long requestsPerLast24Hours;
        Long peakComponentTotalCountsPerDay30d;
        Gauge usersCountGauge;
        LinkedHashMap<String, Object> counts = new LinkedHashMap<String, Object>();
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)DATE_FORMAT_YYYY_MM_DD);
        counts.put(DATE, dateTimeFormatter.print((ReadableInstant)DateTime.now()));
        Counter componentsCount = (Counter)this.usageRegistry.getCounters().get("component_total_count");
        if (componentsCount != null) {
            counts.put("component_total_count", componentsCount.getCount());
        }
        if ((usersCountGauge = (Gauge)this.analyticsRegistry.getGauges().get("nexus.analytics.unique_user_authentications_count")) != null && usersCountGauge.getValue() != null && ((Map)usersCountGauge.getValue()).get(SUCCESSFUL_LAST_30_D_METRIC) != null) {
            counts.put(UNIQUE_USERS_LAST_30_D_KEY, ((Map)usersCountGauge.getValue()).get(SUCCESSFUL_LAST_30_D_METRIC));
        }
        if ((peakComponentTotalCountsPerDay30d = this.getPeakComponentTotalCountsPerDay30d()) != null) {
            counts.put("peak_component_total_count_per_day_30d", peakComponentTotalCountsPerDay30d);
        }
        if ((requestsPerLast24Hours = this.getRequestsPerLast24Hours()) != null) {
            counts.put("requests_per_last_24h", requestsPerLast24Hours);
        }
        if ((aggregatedComponentsCount = this.getAggregatedComponentsCount()) != null) {
            counts.put("aggregated_components_count", aggregatedComponentsCount);
        }
        if ((requestCountsGauge = (Gauge)this.analyticsRegistry.getGauges().get("nexus.analytics.content_request_rates")) != null && requestCountsGauge.getValue() != null) {
            counts.put(REQUEST_RATES_KEY, requestCountsGauge.getValue());
        }
        return counts;
    }

    private Long getAggregatedComponentsCount() {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime minusOneHour = now.minusHours(1L);
        return this.aggregatedMetricsStore.getMaxMetricValue("component_total_count", minusOneHour, now, AnalyticsConstants.AggregationPeriod.hour.name());
    }

    private Long getPeakComponentTotalCountsPerDay30d() {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime minusDays = now.minusDays(30L);
        return this.aggregatedMetricsStore.getMaxMetricValue("component_total_count", minusDays, now, AnalyticsConstants.AggregationPeriod.day.name());
    }

    private Long getRequestsPerLast24Hours() {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime minus24h = now.minusHours(24L);
        return this.aggregatedMetricsStore.getMaxMetricValue("content_request_count", minus24h, now, AnalyticsConstants.AggregationPeriod.last_24h.name());
    }
}

