/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ThroughputRequestMeterGauge
implements Gauge<Map<String, Object>> {
    private final Map<Long, Meter> meters = new ConcurrentHashMap<Long, Meter>();
    private final long MILLISECONDS_IN_MINUTE = 60000L;
    private final long MINUTES_IN_24_HRS = 1440L;
    private final long MINUTES_IN_30_DAYS = 43200L;

    public Map<String, Object> getValue() {
        long currentTimeMinutes = this.getCurrentTimeMinutes();
        return ImmutableMap.of((Object)"peak_requests_per_minute_1d", (Object)this.getMaxRpmStartingFrom(currentTimeMinutes - 1440L), (Object)"peak_requests_per_day_30d", (Object)this.getMaxRpdStartingFrom(currentTimeMinutes - 43200L));
    }

    public void mark() {
        this.meters.computeIfAbsent(this.getCurrentTimeMinutes(), s -> new Meter()).mark();
    }

    protected long getCurrentTimeMinutes() {
        return System.currentTimeMillis() / 60000L;
    }

    private long getMaxRpmStartingFrom(long startingFrom) {
        return this.meters.entrySet().stream().filter(e -> (Long)e.getKey() >= startingFrom).mapToLong(e -> ((Meter)e.getValue()).getCount()).max().orElse(0L);
    }

    private long getMaxRpdStartingFrom(long startingFrom) {
        Map<Long, Long> rpd = this.meters.entrySet().stream().filter(e -> (Long)e.getKey() >= startingFrom).collect(Collectors.groupingBy(entry -> (Long)entry.getKey() / 1440L, Collectors.summingLong(entry -> ((Meter)entry.getValue()).getCount())));
        return rpd.values().stream().mapToLong(value -> value).max().orElse(0L);
    }
}

