/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ServiceRestRequestMeterGauge
implements Gauge<List<Map<String, Object>>> {
    private static final String SEPARATOR = "::";
    private final Map<String, Meter> meters = new ConcurrentHashMap<String, Meter>();

    public List<Map<String, Object>> getValue() {
        return this.transformFormatRequestRates(this.meters);
    }

    public void mark(String method, String uri) {
        this.mark(this.named(method, uri));
    }

    private void mark(String meterName) {
        this.meters.computeIfAbsent(meterName, s -> new Meter()).mark();
    }

    private List<Map<String, Object>> transformFormatRequestRates(Map<String, Meter> meters) {
        return meters.entrySet().stream().map(this::createRequestRateMap).collect(Collectors.toList());
    }

    private Map<String, Object> createRequestRateMap(Map.Entry<String, Meter> e) {
        String[] parts = e.getKey().split(SEPARATOR);
        return ImmutableMap.of((Object)"method", (Object)parts[0], (Object)"uri", (Object)parts[1], (Object)"count", (Object)e.getValue().getCount(), (Object)"requests_per_sec", (Object)e.getValue().getMeanRate());
    }

    private String named(String ... name) {
        return String.join((CharSequence)SEPARATOR, name);
    }
}

