/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class FormatTypeResponseCodeMeterGauge
implements Gauge<List<Map<String, Object>>> {
    public static final String SEPARATOR = "::";
    private final ConcurrentHashMap<String, Meter> meters;

    public FormatTypeResponseCodeMeterGauge() {
        this.meters = new ConcurrentHashMap();
    }

    @VisibleForTesting
    public FormatTypeResponseCodeMeterGauge(Map<String, Meter> meters) {
        this.meters = new ConcurrentHashMap<String, Meter>(meters);
    }

    static List<Map<String, Object>> transformFormatRequestRates(Map<String, Meter> meters) {
        return meters.entrySet().stream().map(FormatTypeResponseCodeMeterGauge::createRequestRateMap).collect(Collectors.toList());
    }

    private static Map<String, Object> createRequestRateMap(Map.Entry<String, Meter> e) {
        String[] parts = e.getKey().split(SEPARATOR);
        return ImmutableMap.of((Object)"format", (Object)parts[0], (Object)"type", (Object)parts[1], (Object)"status", (Object)parts[2], (Object)"count", (Object)e.getValue().getCount(), (Object)"requests_per_sec", (Object)e.getValue().getMeanRate());
    }

    public List<Map<String, Object>> getValue() {
        return FormatTypeResponseCodeMeterGauge.transformFormatRequestRates(this.meters);
    }

    public void mark(String meterName) {
        this.meters.computeIfAbsent(meterName, s -> new Meter()).mark();
    }

    public static String named(String ... name) {
        return String.join((CharSequence)SEPARATOR, name);
    }

    @VisibleForTesting
    public void reset() {
        this.meters.clear();
    }
}

