/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.metrics;

import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.security.authc.NexusAuthenticationEvent;

@Named
@Singleton
public class AccountActivityCacheService
implements EventAware {
    private final Map<String, Long> successfulLogins = new ConcurrentHashMap<String, Long>();

    @Subscribe
    public void on(NexusAuthenticationEvent event) {
        String userName = event.getClientInfo().getUserid();
        if (event.isSuccessful()) {
            this.successfulLogins.put(userName, event.getEventDate().getTime());
        }
    }

    public Map<String, Long> getSuccessfulLogins() {
        return Collections.unmodifiableMap(this.successfulLogins);
    }

    public void clearCache() {
        this.successfulLogins.clear();
    }
}

