/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Format;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class BytesTransferredAnalyticsMarker
implements AnalyticsMarker {
    private final List<Format> formats;
    private final MetricRegistry metricRegistry;

    @Inject
    public BytesTransferredAnalyticsMarker(List<Format> formats, MetricRegistry metricRegistry) {
        this.formats = formats;
        this.metricRegistry = metricRegistry;
    }

    @Override
    public void reset() {
        this.metricRegistry.remove("nexus.analytics.bytes_downloaded_by_format");
        this.formats.forEach(format -> {
            boolean bl = this.metricRegistry.remove("bytes_downloaded_by_format_" + format);
        });
        this.metricRegistry.remove("nexus.analytics.bytes_uploaded_by_format");
        this.formats.forEach(format -> {
            boolean bl = this.metricRegistry.remove("bytes_uploaded_by_format_" + format);
        });
    }

    @CachedGauge(name="nexus.analytics.bytes_transferred_by_format", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Map<String, Long>>> bytesTransferredByFormat() {
        return this.formats.stream().map(format -> {
            Counter downloadCounter = this.metricRegistry.counter("bytes_downloaded_by_format_" + format);
            Counter uploadedCounter = this.metricRegistry.counter("bytes_uploaded_by_format_" + format);
            return this.toMap(format.getValue(), downloadCounter.getCount(), uploadedCounter.getCount());
        }).collect(Collectors.toList());
    }

    private Map<String, Map<String, Long>> toMap(String format, long downloadCount, long uploadCount) {
        return ImmutableMap.of((Object)format, (Object)ImmutableMap.of((Object)"bytes_downloaded", (Object)downloadCount, (Object)"bytes_uploaded", (Object)uploadCount));
    }
}

