/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.MetricRegistry;
import com.sonatype.analytics.internal.handler.AnalyticsBytesTransferredHandler;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsUploadHandler
extends AnalyticsBytesTransferredHandler {
    @Inject
    public AnalyticsUploadHandler(MetricRegistry metricRegistry) {
        super(metricRegistry, "bytes_uploaded_by_format");
    }

    @Override
    protected Optional<Payload> isValidRequestType(Request request, Response response) {
        String action = request.getAction();
        Payload payload = request.getPayload();
        if (("POST".equals(action) || "PUT".equals(action)) && response.getStatus().isSuccessful() && payload != null && payload.getSize() != -1L) {
            return Optional.of(payload);
        }
        return Optional.empty();
    }
}

