/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.annotation.CachedGauge;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named(value="nexus.analytics.nuget.odataRequestsAnalytics")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsNugetOdataRequestsHandler
extends ComponentSupport
implements Handler,
AnalyticsMarker {
    protected static final String ANALYTICS_NUGET_ODATA_REQUESTS_HANDLER = "nexus.analytics.nuget.odataRequestsAnalytics";
    public static final String NUGET_V2_DEPRECATED_REQUEST_ATTRIBUTE_KEY = "NUGET_V2_DEPRECATED_REQUEST";
    private final Map<String, Integer> deprecatedRequestsStatistics = new ConcurrentHashMap<String, Integer>();

    @CachedGauge(name="nexus.analytics.nuget.v2.odataDeprecatedRequestsCount", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Integer> deprecatedRequestsStatistics() {
        return this.deprecatedRequestsStatistics;
    }

    private void countOdataRequests(String requestDescription) {
        this.deprecatedRequestsStatistics.compute(requestDescription, (k, v) -> v == null ? 1 : v + 1);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String deprecatedRequest = (String)context.getAttributes().get(NUGET_V2_DEPRECATED_REQUEST_ATTRIBUTE_KEY, String.class);
        if (deprecatedRequest != null) {
            this.countOdataRequests(deprecatedRequest);
        }
        return context.proceed();
    }

    @Override
    public void reset() {
        this.deprecatedRequestsStatistics.clear();
    }
}

