/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.metrics.FormatTypeResponseCodeMeterGauge;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named(value="nexus.analytics.meteringHandler")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsMeteringHandler
extends ComponentSupport
implements Handler,
AnalyticsMarker {
    public static final String FORMAT_REQ_RATES = "format_request_rates";
    public static final String FORMAT_REQ_RATE_GAUGE_NAME = "nexus.analytics.format_request_rates";
    public static final String METERING_HANDLER = "nexus.analytics.meteringHandler";
    private static final String MARKED = "nexus.analytics.format_request_rates.marked";
    private final MetricRegistry metricRegistry;

    @Inject
    public AnalyticsMeteringHandler(MetricRegistry metricRegistry) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        boolean shouldMark;
        boolean bl = shouldMark = !context.getAttributes().contains(MARKED);
        if (shouldMark) {
            context.getAttributes().set(MARKED, (Object)Boolean.TRUE);
        }
        Response response = context.proceed();
        try {
            if (shouldMark) {
                this.mark(context, response);
            }
        }
        catch (Exception e) {
            this.log.error("Error metering request", (Throwable)e);
        }
        return response;
    }

    @Override
    public void reset() {
        this.metricRegistry.remove(FORMAT_REQ_RATE_GAUGE_NAME);
    }

    private void mark(Context context, Response response) {
        Type type = context.getRepository().getType();
        Format format = context.getRepository().getFormat();
        String meterName = FormatTypeResponseCodeMeterGauge.named(format.getValue(), type.getValue(), this.getStatusFamily(response.getStatus().getCode()));
        FormatTypeResponseCodeMeterGauge gauge = (FormatTypeResponseCodeMeterGauge)this.metricRegistry.gauge(FORMAT_REQ_RATE_GAUGE_NAME, FormatTypeResponseCodeMeterGauge::new);
        gauge.mark(meterName);
    }

    private String getStatusFamily(int status) {
        int group = status / 100;
        if (group > 0) {
            return String.valueOf(group) + "xx";
        }
        return "unknown";
    }
}

