/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.annotation.CachedGauge;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named(value="nexus.analytics.conan.revisionsRequestsHandler")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsConanRevisionsRequestsHandler
extends ComponentSupport
implements Handler,
AnalyticsMarker {
    private final AtomicInteger requestsCount = new AtomicInteger(0);

    @CachedGauge(name="nexus.analytics.conan_revisions_requests_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public int getRequestsCount() {
        return this.requestsCount.get();
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        this.requestsCount.incrementAndGet();
        return context.proceed();
    }

    @Override
    public void reset() {
        this.requestsCount.set(0);
    }
}

