/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.handlers.ContributedHandler;

public abstract class AnalyticsBytesTransferredHandler
extends ComponentSupport
implements ContributedHandler {
    private final String analyticsConstant;
    private final MetricRegistry metricRegistry;

    protected AnalyticsBytesTransferredHandler(MetricRegistry metricRegistry, String analyticsConstant) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.analyticsConstant = analyticsConstant;
    }

    protected abstract Optional<Payload> isValidRequestType(Request var1, Response var2);

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Response response = context.proceed();
        try {
            Request request = context.getRequest();
            this.isValidRequestType(request, response).ifPresent(payload -> {
                Repository repository = context.getRepository();
                Format format = repository.getFormat();
                Counter counter = this.metricRegistry.counter(String.valueOf(this.analyticsConstant) + "_" + format.getValue());
                counter.inc(payload.getSize());
            });
        }
        catch (Exception e) {
            this.log.debug("Failed to record request analytics", (Throwable)e);
        }
        return response;
    }
}

