/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.filter;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.metrics.ThroughputRequestMeterGauge;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.app.FeatureFlag;

@Singleton
@Named
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class ThroughputMetricsFilter
extends AdviceFilter
implements AnalyticsMarker {
    protected final Logger log = Loggers.getLogger((Object)this);
    private final MetricRegistry metricRegistry;
    private final Counter counter;

    @Inject
    public ThroughputMetricsFilter(MetricRegistry metricRegistry, @Named(value="usage") @Named(value="usage") MetricRegistry usageRegistry) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.counter = ((MetricRegistry)Preconditions.checkNotNull((Object)usageRegistry)).counter("content_request_count");
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) {
        try {
            this.counter.inc();
            this.gauge().mark();
            if (this.log.isDebugEnabled()) {
                String path = ((HttpServletRequestWrapper)request).getRequestURI();
                this.log.debug("Collecting analytics for request {}", (Object)path);
            }
        }
        catch (Exception e) {
            this.log.error("Error metering request {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
        }
        return true;
    }

    @Override
    public void reset() {
        this.metricRegistry.remove("nexus.analytics.content_request_rates");
    }

    private ThroughputRequestMeterGauge gauge() {
        return (ThroughputRequestMeterGauge)this.metricRegistry.gauge("nexus.analytics.content_request_rates", ThroughputRequestMeterGauge::new);
    }
}

