/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.filter;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.metrics.ThroughputRequestMeterGauge;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.shiro.web.servlet.AdviceFilter;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;

@Singleton
@Named
public class RealtimeThroughputMetricsFilter
extends AdviceFilter
implements AnalyticsMarker {
    protected final Logger log = Loggers.getLogger((Object)this);
    public static final String CONTENT_REQUEST_REALTIME_GAUGE_NAME = "content_requests";
    private final MetricRegistry realtimeMetricRegistry;

    @Inject
    public RealtimeThroughputMetricsFilter(@Named(value="usage") @Named(value="usage") MetricRegistry realtimeMetricRegistry) {
        this.realtimeMetricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)realtimeMetricRegistry);
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) {
        try {
            this.realtimeGauge().mark();
            if (this.log.isDebugEnabled()) {
                String path = ((HttpServletRequestWrapper)request).getRequestURI();
                this.log.debug("Collecting analytics for request {}", (Object)path);
            }
        }
        catch (Exception e) {
            this.log.error("Error metering request {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
        }
        return true;
    }

    private ThroughputRequestMeterGauge realtimeGauge() {
        return (ThroughputRequestMeterGauge)this.realtimeMetricRegistry.gauge(CONTENT_REQUEST_REALTIME_GAUGE_NAME, ThroughputRequestMeterGauge::new);
    }
}

