/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator.calculator;

import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.evaluator.AggregatePeriodicEntry;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.internal.evaluator.calculator.EvaluatorResultCalculator;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import com.sonatype.analytics.limits.ContentUsageLimits;
import com.sonatype.analytics.limits.ContentUtilization;
import com.sonatype.analytics.limits.LimitEntry;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class UniqueLoginsWithAggregationCalculator
implements EvaluatorResultCalculator {
    private final AggregatedMetricsStore aggregatedMetricsStore;

    @Inject
    public UniqueLoginsWithAggregationCalculator(AggregatedMetricsStore aggregatedMetricsStore) {
        this.aggregatedMetricsStore = Objects.requireNonNull(aggregatedMetricsStore);
    }

    @Override
    public EvaluatorResult calculate() {
        OffsetDateTime now = OffsetDateTime.now();
        long uniqueLogins = this.getMetric(now);
        List<LimitEntry> limits = ContentUsageLimits.getLimitsForMetric("uniqueLogins");
        ContentUtilization contentUtilization = ContentUsageLimits.getContentUtilization("uniqueLogins", uniqueLogins);
        AggregatePeriodicEntry maxAggregate30days = this.getMaxAggregate30days(now);
        return new EvaluatorResult("successful_last_24h", uniqueLogins, limits, contentUtilization, Collections.singletonList(maxAggregate30days));
    }

    @Override
    public List<String> getListOfTargetLicenseAndDbType() {
        return Collections.unmodifiableList(Arrays.asList("OSS_ORIENT", "OSS_H2", "PRO-STARTER_ORIENT", "PRO-STARTER_H2", "PRO-STARTER_POSTGRESQL"));
    }

    private long getMetric(OffsetDateTime now) {
        List<AggregatedMetric> metrics = this.aggregatedMetricsStore.browse("unique_user_count", now.minusHours(1L), now, AnalyticsConstants.AggregationPeriod.last_24h.toString());
        if (!metrics.isEmpty()) {
            return metrics.get(0).getMetricValue();
        }
        return 0L;
    }

    private AggregatePeriodicEntry getMaxAggregate30days(OffsetDateTime now) {
        Long last30DaysMetricValue = this.aggregatedMetricsStore.browse("unique_user_count", now.minusHours(1L), now, AnalyticsConstants.AggregationPeriod.last_30d.toString()).stream().findFirst().map(AggregatedMetric::getMetricValue).orElse(0L);
        return new AggregatePeriodicEntry("unique_user_count", last30DaysMetricValue, "peak_recorded_count_30d");
    }
}

