/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator.calculator;

import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.internal.evaluator.calculator.EvaluatorResultCalculator;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import com.sonatype.analytics.limits.ContentUtilization;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class TotalComponentCountCalculator
implements EvaluatorResultCalculator {
    private final AggregatedMetricsStore aggregatedMetricsStore;

    @Inject
    public TotalComponentCountCalculator(AggregatedMetricsStore aggregatedMetricsStore) {
        this.aggregatedMetricsStore = aggregatedMetricsStore;
    }

    @Override
    public EvaluatorResult calculate() {
        OffsetDateTime now = OffsetDateTime.now();
        List<AggregatedMetric> metrics = this.aggregatedMetricsStore.browse("component_total_count", now.minusHours(1L), now, AnalyticsConstants.AggregationPeriod.hour.toString());
        long totalComponentsCount = metrics.isEmpty() ? 0L : metrics.get(0).getMetricValue();
        return new EvaluatorResult("component_total_count", totalComponentsCount, Collections.emptyList(), ContentUtilization.FULL);
    }

    @Override
    public List<String> getListOfTargetLicenseAndDbType() {
        return Collections.singletonList("PRO_POSTGRESQL");
    }
}

