/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator.calculator;

import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.evaluator.AggregatePeriodicEntry;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.internal.evaluator.calculator.EvaluatorResultCalculator;
import com.sonatype.analytics.internal.metrics.MetricStore;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class RequestsPerMinuteWithAggregationCalculator
implements EvaluatorResultCalculator {
    private final MetricStore metricStore;

    @Inject
    public RequestsPerMinuteWithAggregationCalculator(MetricStore metricStore) {
        this.metricStore = Objects.requireNonNull(metricStore);
    }

    @Override
    public EvaluatorResult calculate() {
        OffsetDateTime now = OffsetDateTime.now();
        long peakRequestsPerMinute24hours = this.metricStore.getMaxMetricValue("content_request_count", now.minusHours(24L), now);
        long peakRequestsPerMinute30days = this.metricStore.getMaxMetricValue("content_request_count", now.minusDays(30L), now);
        return this.buildEvaluatorResult(peakRequestsPerMinute24hours, peakRequestsPerMinute30days);
    }

    @Override
    public List<String> getListOfTargetLicenseAndDbType() {
        return Collections.unmodifiableList(Arrays.asList("PRO_ORIENT", "PRO_H2"));
    }

    private EvaluatorResult buildEvaluatorResult(long peakRequestsPerMinute24hours, long peakRequestsPerMinute30days) {
        return new EvaluatorResult("requests_per_minute", null, null, null, Arrays.asList(new AggregatePeriodicEntry("peak_recorded_count", peakRequestsPerMinute24hours, AnalyticsConstants.AggregationPeriod.last_24h.toString()), new AggregatePeriodicEntry("peak_recorded_count", peakRequestsPerMinute30days, AnalyticsConstants.AggregationPeriod.last_30d.toString())));
    }
}

