/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator.calculator;

import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.internal.evaluator.calculator.EvaluatorResultCalculator;
import com.sonatype.analytics.internal.metrics.MetricStore;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class RequestsPerMinuteCalculator
implements EvaluatorResultCalculator {
    private final MetricStore metricStore;

    @Inject
    public RequestsPerMinuteCalculator(MetricStore metricStore) {
        this.metricStore = Objects.requireNonNull(metricStore);
    }

    @Override
    public EvaluatorResult calculate() {
        OffsetDateTime now = OffsetDateTime.now();
        long peakRequestsPerMinute24hours = this.metricStore.getMaxMetricValue("content_request_count", now.minusHours(24L), now);
        return this.buildEvaluatorResult(peakRequestsPerMinute24hours);
    }

    @Override
    public List<String> getListOfTargetLicenseAndDbType() {
        return Collections.singletonList("PRO_POSTGRESQL");
    }

    private EvaluatorResult buildEvaluatorResult(long peakRequestsPerMinute24hours) {
        return new EvaluatorResult("requests_per_minute", peakRequestsPerMinute24hours, null, null);
    }
}

