/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator.calculator;

import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.evaluator.AggregatePeriodicEntry;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.internal.evaluator.calculator.EvaluatorResultCalculator;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import com.sonatype.analytics.limits.ContentUsageLimits;
import com.sonatype.analytics.limits.ContentUtilization;
import com.sonatype.analytics.limits.LimitEntry;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class RequestsPerDayWithAggregationCalculator
implements EvaluatorResultCalculator {
    private final AggregatedMetricsStore aggregatedMetricsStore;

    @Inject
    public RequestsPerDayWithAggregationCalculator(AggregatedMetricsStore aggregatedMetricsStore) {
        this.aggregatedMetricsStore = Objects.requireNonNull(aggregatedMetricsStore);
    }

    @Override
    public EvaluatorResult calculate() {
        OffsetDateTime now = OffsetDateTime.now();
        long requestsPerDay = this.getMetric(now);
        List<LimitEntry> limits = ContentUsageLimits.getLimitsForMetric("requestsPerDay");
        ContentUtilization contentUtilization = ContentUsageLimits.getContentUtilization("requestsPerDay", requestsPerDay);
        AggregatePeriodicEntry maxAggregate30days = this.getMaxAggregate30days(now);
        return new EvaluatorResult("peak_requests_per_day", requestsPerDay, limits, contentUtilization, Collections.singletonList(maxAggregate30days));
    }

    @Override
    public List<String> getListOfTargetLicenseAndDbType() {
        return Collections.unmodifiableList(Arrays.asList("OSS_ORIENT", "OSS_H2", "PRO_ORIENT", "PRO_H2", "PRO-STARTER_ORIENT", "PRO-STARTER_H2", "PRO-STARTER_POSTGRESQL"));
    }

    private long getMetric(OffsetDateTime now) {
        return this.aggregatedMetricsStore.browse("content_request_count", now.minusHours(1L), now, AnalyticsConstants.AggregationPeriod.last_24h.toString()).stream().mapToLong(AggregatedMetric::getMetricValue).sum();
    }

    private AggregatePeriodicEntry getMaxAggregate30days(OffsetDateTime now) {
        OffsetDateTime minus30Days = now.minusDays(30L);
        Long maxMetricValue = this.aggregatedMetricsStore.getMaxMetricValue("content_request_count", minus30Days, now, AnalyticsConstants.AggregationPeriod.last_24h.toString());
        maxMetricValue = maxMetricValue == null ? 0L : maxMetricValue;
        return new AggregatePeriodicEntry("content_request_count", maxMetricValue, "peak_recorded_count_30d");
    }
}

