/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator.calculator;

import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.internal.evaluator.calculator.EvaluatorResultCalculator;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import com.sonatype.analytics.limits.ContentUtilization;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class RequestsPerDayCalculator
implements EvaluatorResultCalculator {
    private final AggregatedMetricsStore aggregatedMetricsStore;

    @Inject
    public RequestsPerDayCalculator(AggregatedMetricsStore aggregatedMetricsStore) {
        this.aggregatedMetricsStore = Objects.requireNonNull(aggregatedMetricsStore);
    }

    @Override
    public EvaluatorResult calculate() {
        OffsetDateTime now = OffsetDateTime.now();
        long requestsPerDay = this.aggregatedMetricsStore.getMaxMetricValue("content_request_count", now.minusDays(30L), now, AnalyticsConstants.AggregationPeriod.last_24h.toString());
        return new EvaluatorResult("peak_requests_per_day_30d", requestsPerDay, Collections.emptyList(), ContentUtilization.FULL);
    }

    @Override
    public List<String> getListOfTargetLicenseAndDbType() {
        return Collections.singletonList("PRO_POSTGRESQL");
    }
}

