/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator;

import com.sonatype.analytics.internal.evaluator.AggregatePeriodicEntry;
import com.sonatype.analytics.limits.ContentUtilization;
import com.sonatype.analytics.limits.LimitEntry;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EvaluatorResult {
    private final String metricName;
    private final Long metricValue;
    private final List<LimitEntry> thresholds;
    private final ContentUtilization utilization;
    private final List<AggregatePeriodicEntry> aggregates;

    public EvaluatorResult(String metricName, Long metricValue, List<LimitEntry> thresholds, ContentUtilization utilization, List<AggregatePeriodicEntry> aggregates) {
        this.metricName = metricName;
        this.metricValue = metricValue;
        this.thresholds = thresholds;
        this.utilization = utilization;
        this.aggregates = aggregates;
    }

    public EvaluatorResult(String metricName, Long metricValue, List<LimitEntry> thresholds, ContentUtilization utilization) {
        this(metricName, metricValue, thresholds, utilization, Collections.emptyList());
    }

    public String getMetricName() {
        return this.metricName;
    }

    public Long getMetricValue() {
        return this.metricValue;
    }

    public List<LimitEntry> getLimits() {
        return this.thresholds;
    }

    public ContentUtilization getUtilization() {
        return this.utilization;
    }

    public List<AggregatePeriodicEntry> getAggregates() {
        return this.aggregates;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EvaluatorResult that = (EvaluatorResult)object;
        return Objects.equals(this.metricName, that.metricName) && Objects.equals(this.metricValue, that.metricValue) && Objects.equals(this.thresholds, that.thresholds) && this.utilization == that.utilization && Objects.equals(this.aggregates, that.aggregates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metricName, this.metricValue, this.thresholds, this.utilization, this.aggregates});
    }

    public String toString() {
        return "EvaluatorResult{metricName='" + this.metricName + '\'' + ", metricValue=" + this.metricValue + ", thresholds=" + this.thresholds + ", utilization=" + (Object)((Object)this.utilization) + ", aggregates=" + this.aggregates + '}';
    }
}

