/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator;

import com.sonatype.analytics.internal.circuit.ContentUsageCircuitBreaker;
import com.sonatype.analytics.internal.circuit.ContentUsageCircuitBreakerFeatureFlag;
import com.sonatype.analytics.internal.evaluator.ContentUsageEvaluator;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.limits.ContentUtilization;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;

@Named
@Singleton
public class ContentUsageEvaluatorManager
extends ComponentSupport {
    private static final String PRO_EDITION = "PRO";
    private final ContentUsageEvaluator evaluator;
    private final ContentUsageCircuitBreaker circuitBreaker;
    private final ApplicationVersion applicationVersion;
    private final ContentUsageCircuitBreakerFeatureFlag circuitBreakerFeatureFlag;
    private final AtomicReference<List<EvaluatorResult>> evaluatorResults = new AtomicReference(Collections.emptyList());

    @Inject
    public ContentUsageEvaluatorManager(ApplicationVersion applicationVersion, ContentUsageCircuitBreaker circuitBreaker, ContentUsageEvaluator evaluator, ContentUsageCircuitBreakerFeatureFlag circuitBreakerFeatureFlag) {
        this.applicationVersion = Objects.requireNonNull(applicationVersion);
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker);
        this.circuitBreakerFeatureFlag = Objects.requireNonNull(circuitBreakerFeatureFlag);
        this.evaluator = Objects.requireNonNull(evaluator);
    }

    public List<EvaluatorResult> getEvaluatorResults() {
        return this.evaluatorResults.get();
    }

    public void evaluateUsage() {
        List<EvaluatorResult> evaluationResults = this.calculateEvaluatorResults();
        this.evaluatorResults.set(evaluationResults);
        ContentUtilization contentUtilization = this.extractContentUtilization(evaluationResults);
        this.circuitBreaker.setUsageLevel(contentUtilization);
    }

    private List<EvaluatorResult> calculateEvaluatorResults() {
        List<EvaluatorResult> evaluationResults = this.evaluator.getEvaluatorResults();
        if (this.circuitBreakerFeatureFlag.isEnabled()) {
            return evaluationResults;
        }
        return evaluationResults.stream().map(it -> new EvaluatorResult(it.getMetricName(), it.getMetricValue(), Collections.emptyList(), this.applicationVersion.getEdition().equals(PRO_EDITION) ? ContentUtilization.FULL : ContentUtilization.FREE_TIER, it.getAggregates())).collect(Collectors.toList());
    }

    private ContentUtilization extractContentUtilization(List<EvaluatorResult> evaluatorResults) {
        if (this.applicationVersion.getEdition().equals(PRO_EDITION)) {
            return ContentUtilization.FULL;
        }
        if (evaluatorResults.stream().anyMatch(it -> it.getUtilization() == ContentUtilization.STARTER_THRESHOLD)) {
            return ContentUtilization.STARTER_THRESHOLD;
        }
        if (evaluatorResults.stream().anyMatch(it -> it.getUtilization() == ContentUtilization.SOFT_THRESHOLD)) {
            return ContentUtilization.SOFT_THRESHOLD;
        }
        return ContentUtilization.FREE_TIER;
    }
}

