/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.evaluator;

import com.sonatype.analytics.internal.evaluator.ContentUsageEvaluator;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import com.sonatype.analytics.internal.evaluator.TargetLicenseAndDbType;
import com.sonatype.analytics.internal.evaluator.calculator.EvaluatorResultCalculator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.db.DatabaseCheck;

@Named
@Singleton
public class ContentUsageEvaluatorImpl
extends ComponentSupport
implements ContentUsageEvaluator {
    private final String dbAndApplicationEdition;
    private final List<EvaluatorResultCalculator> evaluatorResultCalculators;

    @Inject
    public ContentUsageEvaluatorImpl(@Named(value="nexus.orient.enabled") @Named(value="nexus.orient.enabled") boolean orientEnabled, DatabaseCheck dbCheck, ApplicationVersion applicationVersion, List<EvaluatorResultCalculator> evaluatorResultCalculators) {
        this.dbAndApplicationEdition = TargetLicenseAndDbType.determineTargetLicenseAndDbType(orientEnabled, dbCheck.isPostgresql(), Objects.requireNonNull(applicationVersion).getEdition());
        this.evaluatorResultCalculators = this.filterCalculators(Objects.requireNonNull(evaluatorResultCalculators));
    }

    @Override
    public List<EvaluatorResult> getEvaluatorResults() {
        return this.evaluatorResultCalculators.stream().map(EvaluatorResultCalculator::calculate).collect(Collectors.toList());
    }

    private List<EvaluatorResultCalculator> filterCalculators(List<EvaluatorResultCalculator> calculators) {
        this.log.debug("Filtering EvaluatorResultCalculator for {} ", (Object)this.dbAndApplicationEdition);
        List<EvaluatorResultCalculator> filteredCalculators = calculators.stream().filter(e -> e.getListOfTargetLicenseAndDbType().contains(this.dbAndApplicationEdition)).collect(Collectors.toList());
        if (filteredCalculators.isEmpty()) {
            throw new IllegalStateException(String.format("No appropriate evaluator found for %s edition", this.dbAndApplicationEdition));
        }
        this.log.debug("Filtered EvaluatorResultCalculator list {} ", filteredCalculators);
        return filteredCalculators;
    }
}

