/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.email;

import com.codahale.metrics.annotation.CachedGauge;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.email.EmailConfiguration;
import org.sonatype.nexus.email.EmailManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class EmailConfigurationAnalytics
implements AnalyticsMarker {
    private final EmailManager emailManager;

    @Inject
    public EmailConfigurationAnalytics(EmailManager emailManager) {
        this.emailManager = emailManager;
    }

    @CachedGauge(name="nexus.analytics.email_configuration", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> emailConfiguration() {
        return this.convert(this.emailManager.getConfiguration());
    }

    protected Map<String, Object> convert(EmailConfiguration emailConfiguration) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("enabled", emailConfiguration.isEnabled());
        config.put("nexusTrustStoreEnabled", emailConfiguration.isNexusTrustStoreEnabled());
        config.put("sslCheckServerIdentityEnabled", emailConfiguration.isSslCheckServerIdentityEnabled());
        config.put("sslOnConnectEnabled", emailConfiguration.isSslOnConnectEnabled());
        config.put("startTlsEnabled", emailConfiguration.isStartTlsEnabled());
        config.put("startTlsRequired", emailConfiguration.isStartTlsRequired());
        config.put("hostConfigured", StringUtils.isNotBlank((String)emailConfiguration.getHost()));
        config.put("passwordConfigured", StringUtils.isNotBlank((String)emailConfiguration.getPassword()));
        config.put("portConfigured", emailConfiguration.getPort() != 0);
        config.put("subjectPrefixConfigured", StringUtils.isNotBlank((String)emailConfiguration.getSubjectPrefix()));
        config.put("usernameConfigured", StringUtils.isNotBlank((String)emailConfiguration.getUsername()));
        return config;
    }
}

