/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.dependencysnippets;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/dependency_snippets")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class DependencySnippetsResource
extends ComponentSupport
implements Resource,
AnalyticsMarker {
    public static final String RESOURCE_URI = "/dependency_snippets";
    private static final String SEPARATOR = "::";
    @VisibleForTesting
    static final String FORMAT_KEY = "format";
    @VisibleForTesting
    static final String SNIPPET_KEY = "snippet";
    @VisibleForTesting
    static final String COUNT_KEY = "count";
    @VisibleForTesting
    static final String GAUGE_NAME = "nexus.analytics.dependency_snippets";
    private MetricRegistry metricRegistry;

    @Inject
    public DependencySnippetsResource(MetricRegistry metricRegistry) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
    }

    @POST
    public void post(@QueryParam(value="format") String format, @QueryParam(value="snippet") String snippet) {
        if (Strings2.isEmpty((String)format) || Strings2.isEmpty((String)snippet)) {
            return;
        }
        DependencySnippetMeterGauge gauge = (DependencySnippetMeterGauge)this.metricRegistry.gauge(GAUGE_NAME, () -> new DependencySnippetMeterGauge());
        String meterName = String.valueOf(format) + SEPARATOR + snippet;
        gauge.mark(meterName);
    }

    @Override
    public void reset() {
        this.metricRegistry.remove(GAUGE_NAME);
    }

    private static final class DependencySnippetMeterGauge
    implements Gauge<List<Map<String, Object>>> {
        private final ConcurrentHashMap<String, Meter> meters = new ConcurrentHashMap();

        private DependencySnippetMeterGauge() {
        }

        private List<Map<String, Object>> transform(Map<String, Meter> meters) {
            return meters.entrySet().stream().map(this::createMap).collect(Collectors.toList());
        }

        private Map<String, Object> createMap(Map.Entry<String, Meter> e) {
            String[] parts = e.getKey().split(DependencySnippetsResource.SEPARATOR);
            return ImmutableMap.of((Object)DependencySnippetsResource.FORMAT_KEY, (Object)parts[0], (Object)DependencySnippetsResource.SNIPPET_KEY, (Object)parts[1], (Object)DependencySnippetsResource.COUNT_KEY, (Object)e.getValue().getCount());
        }

        public List<Map<String, Object>> getValue() {
            return this.transform(this.meters);
        }

        private void mark(String meterName) {
            this.meters.computeIfAbsent(meterName, s -> new Meter()).mark();
        }
    }
}

