/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.contentusage;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.contentusage.ContentUsageAggregationTask;
import com.sonatype.analytics.internal.metrics.MetricStore;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskRemovedException;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Cron;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class ContentUsageMetricReporter
extends StateGuardLifecycleSupport {
    private final MetricStore metricStore;
    private final TaskScheduler taskScheduler;
    private final ContentUsageMetricScheduledReporter usageReporter;
    private final Boolean isContentUsageEnabled;

    @Inject
    public ContentUsageMetricReporter(@Named(value="usage") @Named(value="usage") MetricRegistry usageRegistry, MetricStore metricStore, TaskScheduler taskScheduler, @Named(value="${nexus.contentUsageMetrics.enabled:-true}") @Named(value="${nexus.contentUsageMetrics.enabled:-true}") Boolean featureFlag) {
        this.usageReporter = new ContentUsageMetricScheduledReporter((MetricRegistry)Preconditions.checkNotNull((Object)usageRegistry));
        this.metricStore = (MetricStore)Preconditions.checkNotNull((Object)metricStore);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.isContentUsageEnabled = Boolean.TRUE.equals(featureFlag);
    }

    protected void doStart() {
        this.usageReporter.start(1L, TimeUnit.MINUTES);
        this.scheduleTask();
    }

    private void scheduleTask() {
        this.taskScheduler.listsTasks().stream().filter(task -> ContentUsageAggregationTask.TASK_ID.equals(task.getTypeId())).peek(task -> this.log.trace("Removing task {}", (Object)task.getId())).forEach(TaskInfo::remove);
        boolean shouldSkipSchedulingTask = Boolean.FALSE.equals(this.isContentUsageEnabled);
        if (shouldSkipSchedulingTask) {
            return;
        }
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance(ContentUsageAggregationTask.TASK_ID);
        configuration.setName("Metric aggregation");
        Cron schedule = this.taskScheduler.getScheduleFactory().cron(new Date(), ContentUsageAggregationTask.SCHEDULE);
        TaskInfo taskInfo = this.taskScheduler.scheduleTask(configuration, (Schedule)schedule);
        try {
            taskInfo.runNow();
        }
        catch (TaskRemovedException taskRemovedException) {
            this.log.warn("Unable to run task {} at startup. Task will run on regular schedule.", (Object)configuration.getTaskLogName());
        }
    }

    protected void doStop() {
        if (this.usageReporter != null) {
            this.usageReporter.stop();
        }
    }

    private static boolean filter(String name, Metric metric) {
        switch (name) {
            case "component_total_count": 
            case "content_request_count": {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ boolean access$0(String string, Metric metric) {
        return ContentUsageMetricReporter.filter(string, metric);
    }

    class ContentUsageMetricScheduledReporter
    extends ScheduledReporter {
        private ContentUsageMetricScheduledReporter(MetricRegistry registry) {
            super(registry, "content-usage", ContentUsageMetricReporter::access$0, TimeUnit.SECONDS, TimeUnit.MINUTES);
        }

        public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
            HashMap<String, Long> metrics = new HashMap<String, Long>();
            counters.forEach((name, counter) -> {
                Long l = metrics.put((String)name, this.getValue((String)name, (Counter)counter));
            });
            OffsetDateTime time = OffsetDateTime.now();
            metrics.forEach((name, value) -> ContentUsageMetricReporter.this.metricStore.addMetricData((String)name, (long)value, time));
        }

        private long getValue(String name, Counter counter) {
            switch (name) {
                case "content_request_count": {
                    long count = counter.getCount();
                    counter.dec(count);
                    return count;
                }
            }
            return counter.getCount();
        }
    }
}

