/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.contentusage;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.AnalyticsConstants;
import com.sonatype.analytics.internal.metrics.AggregatedMetric;
import com.sonatype.analytics.internal.metrics.AggregatedMetricsStore;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.analytics.AggregatedEventMetric;
import org.sonatype.nexus.common.analytics.RequestsMetric;

@Named
@Singleton
public class ContentUsageAnalyticsMarker
implements AnalyticsMarker {
    @VisibleForTesting
    static final String HOUR = AnalyticsConstants.AggregationPeriod.hour.toString();
    @VisibleForTesting
    static final String DAY = AnalyticsConstants.AggregationPeriod.day.toString();
    @VisibleForTesting
    static final String LAST_24H = AnalyticsConstants.AggregationPeriod.last_24h.toString();
    @VisibleForTesting
    static final String LAST_30D = AnalyticsConstants.AggregationPeriod.last_30d.toString();
    private final AggregatedMetricsStore metricStore;
    @Nullable
    private final AggregatedEventMetric aggregatedEventMetric;
    @Nullable
    private final RequestsMetric requestsMetric;

    @Inject
    public ContentUsageAnalyticsMarker(AggregatedMetricsStore metricStore, @Nullable AggregatedEventMetric aggregatedEventMetric, @Nullable RequestsMetric requestsMetric) {
        this.metricStore = (AggregatedMetricsStore)Preconditions.checkNotNull((Object)metricStore);
        this.aggregatedEventMetric = aggregatedEventMetric;
        this.requestsMetric = requestsMetric;
    }

    @CachedGauge(name="nexus.analytics.content_request_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> getContentRequests() {
        return this.createMetrics("content_request_count");
    }

    @CachedGauge(name="nexus.analytics.component_history", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> getComponentCounts() {
        return this.createMetrics("component_total_count");
    }

    @CachedGauge(name="nexus.analytics.unique_user_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> getUniqueUserCounts() {
        return this.createMetrics("unique_user_count");
    }

    @CachedGauge(name="nexus.analytics.run_aggregate_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public int blockingStateEventCounter() {
        if (this.aggregatedEventMetric == null) {
            return 0;
        }
        return this.aggregatedEventMetric.get();
    }

    @CachedGauge(name="nexus.analytics.blocked_requests_count", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public long blockedRequestsCounter() {
        if (this.requestsMetric == null) {
            return 0L;
        }
        return this.requestsMetric.get();
    }

    @Override
    public void reset() {
        if (this.aggregatedEventMetric != null) {
            this.aggregatedEventMetric.reset();
        }
        if (this.requestsMetric != null) {
            this.requestsMetric.reset();
        }
    }

    private Map<String, Object> createMetrics(String metricName) {
        OffsetDateTime end = OffsetDateTime.now();
        OffsetDateTime start = end.minusHours(25L);
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        long[] values = ContentUsageAnalyticsMarker.toValueArray(this.metricStore.browse(metricName, start, end, HOUR));
        if (values != null && values.length > 0) {
            metrics.put(HOUR, values);
        }
        this.lastValue(metricName, AnalyticsConstants.AggregationPeriod.day).ifPresent(value -> {
            Long l = metrics.put(DAY, value);
        });
        this.lastValue(metricName, AnalyticsConstants.AggregationPeriod.last_24h).ifPresent(value -> {
            Long l = metrics.put(LAST_24H, value);
        });
        this.lastValue(metricName, AnalyticsConstants.AggregationPeriod.last_30d).ifPresent(value -> {
            Long l = metrics.put(LAST_30D, value);
        });
        return metrics;
    }

    private Optional<Long> lastValue(String metricName, AnalyticsConstants.AggregationPeriod period) {
        return Optional.ofNullable(this.metricStore.getLastValue(metricName, period));
    }

    private static long[] toValueArray(List<AggregatedMetric> metrics) {
        return metrics.stream().sorted(Collections.reverseOrder(ContentUsageAnalyticsMarker::compare)).limit(24L).sorted(ContentUsageAnalyticsMarker::compare).mapToLong(AggregatedMetric::getMetricValue).toArray();
    }

    private static int compare(AggregatedMetric a, AggregatedMetric b) {
        return OffsetDateTime.timeLineOrder().compare(a.getMetricDate(), b.getMetricDate());
    }
}

