/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.circuit;

import com.sonatype.analytics.internal.circuit.ContentUsageCircuitBreakerFeatureFlag;
import com.sonatype.analytics.limits.ContentUtilization;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;

@Named
@Singleton
public class ContentUsageCircuitBreaker
extends ComponentSupport {
    private static final String PRO_EDITION = "PRO";
    private static final String OSS_EDITION = "OSS";
    private final AtomicReference<ContentUtilization> utilization = new AtomicReference();
    private final ApplicationVersion applicationVersion;
    private final ContentUsageCircuitBreakerFeatureFlag circuitBreakerFeatureFlag;

    @Inject
    public ContentUsageCircuitBreaker(ApplicationVersion applicationVersion, ContentUsageCircuitBreakerFeatureFlag circuitBreakerFeatureFlag) {
        this.applicationVersion = Objects.requireNonNull(applicationVersion);
        this.circuitBreakerFeatureFlag = Objects.requireNonNull(circuitBreakerFeatureFlag);
        this.setDefaultLevel();
    }

    private void setDefaultLevel() {
        if (!this.circuitBreakerFeatureFlag.isEnabled()) {
            return;
        }
        if (PRO_EDITION.equals(this.applicationVersion.getEdition())) {
            this.setUsageLevel(ContentUtilization.FULL);
        } else {
            this.setUsageLevel(ContentUtilization.FREE_TIER);
        }
    }

    public ContentUtilization getUsageLevel() {
        return this.utilization.get();
    }

    public void setUsageLevel(ContentUtilization utilization) {
        if (!this.circuitBreakerFeatureFlag.isEnabled()) {
            return;
        }
        if (PRO_EDITION.equals(this.applicationVersion.getEdition()) && utilization == ContentUtilization.FULL || OSS_EDITION.equals(this.applicationVersion.getEdition()) && utilization != ContentUtilization.FULL) {
            this.utilization.set(utilization);
        }
    }

    public boolean isClosed() {
        return this.utilization.get() != ContentUtilization.STARTER_THRESHOLD;
    }
}

