/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.capability;

import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.capability.AnalyticsCapability;
import com.sonatype.analytics.internal.capability.AnalyticsCapabilityConfiguration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.upgrade.AvailabilityVersion;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;

@AvailabilityVersion(from="1.0")
@Named(value="analytics-configuration")
@Singleton
public class AnalyticsCapabilityDescriptor
extends CapabilityDescriptorSupport<AnalyticsCapabilityConfiguration>
implements Taggable {
    static final Messages messages = (Messages)I18N.create(Messages.class);
    private final CheckboxFormField analyticsEnabled;
    private final ApplicationLicense applicationLicense;

    @Inject
    public AnalyticsCapabilityDescriptor(ApplicationLicense applicationLicense) {
        this.applicationLicense = (ApplicationLicense)Preconditions.checkNotNull((Object)applicationLicense);
        this.setExposed(false);
        this.setHidden(true);
        this.analyticsEnabled = new CheckboxFormField("submitAnalytics", messages.submitAnalyticsLabel(), messages.submitAnalyticsHelp(), false);
    }

    public CapabilityType type() {
        return AnalyticsCapability.TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return Collections.singletonList(this.analyticsEnabled);
    }

    protected AnalyticsCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new AnalyticsCapabilityConfiguration(this.applicationLicense, properties);
    }

    protected String renderAbout() {
        return this.render("analytics-configuration-about.vm");
    }

    public void setExposed(boolean exposed) {
        super.setExposed(exposed);
    }

    public Set<Tag> getTags() {
        return Collections.singleton(Tag.categoryTag((String)messages.category()));
    }

    static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Analytics: Configuration")
        public String name();

        @MessageBundle.DefaultMessage(value="Metrics")
        public String category();

        @MessageBundle.DefaultMessage(value="Disabled")
        public String disabled();

        @MessageBundle.DefaultMessage(value="Enabled")
        public String enabled();

        @MessageBundle.DefaultMessage(value="Submit Analytics")
        public String submitAnalyticsLabel();

        @MessageBundle.DefaultMessage(value="Select this option to provide limited metrics about the server to Sonatype.")
        public String submitAnalyticsHelp();
    }
}

