/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.common.app.ApplicationLicense;

public class AnalyticsCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String SUBMIT_ANALYTICS = "submitAnalytics";
    public static final boolean DEFAULT_SUBMIT_ANALYTICS = false;
    private boolean submitAnalytics;

    public AnalyticsCapabilityConfiguration(ApplicationLicense applicationLicense, Map<String, String> properties) {
        Preconditions.checkNotNull((Object)applicationLicense);
        Preconditions.checkNotNull(properties);
        this.submitAnalytics = applicationLicense.isValid() || this.parseBoolean(properties.get(SUBMIT_ANALYTICS), false) != false;
    }

    public boolean isSubmitAnalytics() {
        return this.submitAnalytics;
    }

    public AnalyticsCapabilityConfiguration setSubmitAnalytics(boolean submitAnalytics) {
        this.submitAnalytics = submitAnalytics;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(SUBMIT_ANALYTICS, String.valueOf(this.submitAnalytics));
        return props;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "submitAnalytics=" + this.submitAnalytics + '}';
    }
}

