/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.capability;

import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.capability.AnalyticsCapabilityConfiguration;
import com.sonatype.analytics.internal.capability.AnalyticsCapabilityDescriptor;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.common.app.ApplicationLicense;

@Named(value="analytics-configuration")
public class AnalyticsCapability
extends CapabilitySupport<AnalyticsCapabilityConfiguration> {
    public static final String TYPE_ID = "analytics-configuration";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"analytics-configuration");
    private final ApplicationLicense applicationLicense;

    @Inject
    public AnalyticsCapability(ApplicationLicense applicationLicense) {
        this.applicationLicense = (ApplicationLicense)Preconditions.checkNotNull((Object)applicationLicense);
    }

    protected AnalyticsCapabilityConfiguration createConfig(Map<String, String> properties) {
        return new AnalyticsCapabilityConfiguration(this.applicationLicense, properties);
    }

    @Nullable
    protected String renderDescription() {
        return this.context().isActive() ? AnalyticsCapabilityDescriptor.messages.enabled() : AnalyticsCapabilityDescriptor.messages.disabled();
    }

    public Condition activationCondition() {
        return this.conditions().logical().and(new Condition[]{this.conditions().nexus().active(), this.conditions().capabilities().capabilityHasNoDuplicates(), this.conditions().capabilities().passivateCapabilityDuringUpdate()});
    }

    public boolean isSubmitEnabled() {
        return ((AnalyticsCapabilityConfiguration)((Object)this.getConfig())).isSubmitAnalytics() || this.applicationLicense.isValid();
    }
}

