/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsMarker;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.events.TaskStartedRunningEvent;
import org.sonatype.nexus.script.Script;
import org.sonatype.nexus.script.ScriptManager;
import org.sonatype.nexus.script.ScriptRunEvent;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class ScriptStoreAnalytics
implements AnalyticsMarker,
EventAware {
    private static final int SCRIPT_RUN_INCREMENT = 1;
    private static final int INITIAL_SCRIPT_RUNS = 0;
    protected static final String SCRIPT_TYPE_ID = "script";
    protected static final String SCRIPT_TASK_CONTENT = "source";
    private final ScriptManager scriptManager;
    private final TaskScheduler taskScheduler;
    private final Map<String, Integer> scriptRuns = new ConcurrentHashMap<String, Integer>();

    @Inject
    public ScriptStoreAnalytics(ScriptManager scriptManager, TaskScheduler taskScheduler) {
        this.scriptManager = (ScriptManager)Preconditions.checkNotNull((Object)scriptManager);
        this.taskScheduler = taskScheduler;
    }

    @Override
    public void reset() {
        this.scriptRuns.clear();
    }

    @Subscribe
    public void on(ScriptRunEvent event) {
        String hashedName = this.createSha1Hash(event.getScript().getName());
        this.scriptRuns.put(hashedName, this.scriptRuns.getOrDefault(hashedName, 0) + 1);
    }

    @Subscribe
    public void on(TaskStartedRunningEvent event) {
        if (this.isScriptTask(event.getTaskInfo())) {
            String hashedId = this.createSha1Hash(event.getTaskInfo().getId());
            this.scriptRuns.put(hashedId, this.scriptRuns.getOrDefault(hashedId, 0) + 1);
        }
    }

    @CachedGauge(name="nexus.analytics.scripts_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Long countScripts() {
        return this.fetchScriptsInStore().count() + (long)this.fetchScriptTasks().size();
    }

    @CachedGauge(name="nexus.analytics.scripts", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public List<Map<String, Object>> getScripts() {
        ArrayList<Map<String, Object>> scriptData = new ArrayList<Map<String, Object>>();
        scriptData.addAll(this.fetchScriptsInStore().map(script -> this.toMap(this.createSha1Hash(script.getName()), script.getContent())).collect(Collectors.toList()));
        scriptData.addAll(this.fetchScriptTasks().stream().map(taskInfo -> this.toMap(this.createSha1Hash(taskInfo.getId()), taskInfo.getConfiguration().getString(SCRIPT_TASK_CONTENT))).collect(Collectors.toList()));
        return scriptData;
    }

    private Map<String, Object> toMap(String hashedId, String content) {
        return ImmutableMap.of((Object)"id", (Object)hashedId, (Object)"execution_count", (Object)this.getExecutionCount(hashedId), (Object)"size_bytes", (Object)content.length(), (Object)"content_hash", (Object)this.createSha1Hash(content));
    }

    private int getExecutionCount(String hashedName) {
        Integer count = this.scriptRuns.get(hashedName);
        if (count != null) {
            return count;
        }
        return 0;
    }

    private Stream<Script> fetchScriptsInStore() {
        return StreamSupport.stream(this.scriptManager.browse().spliterator(), false);
    }

    private List<TaskInfo> fetchScriptTasks() {
        return this.taskScheduler.listsTasks().stream().filter(this::isScriptTask).collect(Collectors.toList());
    }

    private boolean isScriptTask(TaskInfo taskInfo) {
        return SCRIPT_TYPE_ID.equalsIgnoreCase(taskInfo.getTypeId());
    }

    private String createSha1Hash(String name) {
        return HashAlgorithm.SHA1.function().hashString((CharSequence)name, StandardCharsets.UTF_8).toString();
    }
}

