/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.collect.Streams;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class RepositoryCountAnalytics
implements AnalyticsMarker {
    public static final String REPLICATION_ATTRIBUTE = "replication";
    public static final String PREEMPTIVE_PULL_ENABLED_ATTRIBUTE = "preemptivePullEnabled";
    private final RepositoryManager repositoryManager;

    @Inject
    public RepositoryCountAnalytics(RepositoryManager repositoryManager) {
        this.repositoryManager = Objects.requireNonNull(repositoryManager);
    }

    @CachedGauge(name="nexus.analytics.repository_total_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public int getRepositoryCount() {
        return this.repositoryManager.count();
    }

    @CachedGauge(name="nexus.analytics.repository_proxy_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long getProxyCount() {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(repository -> repository.getType().getValue().equals("proxy")).count();
    }

    @CachedGauge(name="nexus.analytics.repository_proxy_preemptive_count", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public long getProxyPreemptiveCount() {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(repository -> repository.getType().getValue().equals("proxy")).filter(this::preemptivePullEnabled).count();
    }

    private boolean preemptivePullEnabled(Repository repository) {
        return Boolean.TRUE.equals(repository.getConfiguration().copy().attributes(REPLICATION_ATTRIBUTE).get(PREEMPTIVE_PULL_ENABLED_ATTRIBUTE, Boolean.class));
    }
}

