/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.nexus.clm.ClmConnector;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class ProprietaryRepositoryAnalytics
extends ComponentSupport
implements AnalyticsMarker {
    public static final String FLAG_ENABLED = "proprietaryRepository.flagEnabled";
    public static final String IS_IQ_ENABLED = "proprietaryRepository.isIQEnabled";
    public static final String ENABLED_PER_FORMAT = "proprietaryRepository.enabledPerFormat";
    private final boolean isEnabled;
    private final RepositoryManager repositoryManager;
    private final ClmConnector clmConnector;

    @Inject
    public ProprietaryRepositoryAnalytics(@Named(value="${nexus.firewall.proprietary.names.enabled:-true}") @Named(value="${nexus.firewall.proprietary.names.enabled:-true}") boolean enabled, RepositoryManager repositoryManager, ClmConnector clmConnector) {
        this.isEnabled = enabled;
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.clmConnector = (ClmConnector)Preconditions.checkNotNull((Object)clmConnector);
    }

    @CachedGauge(name="nexus.analytics.proprietaryRepository.flagEnabled", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public boolean isProprietaryFlagEnabled() {
        return this.isEnabled;
    }

    @CachedGauge(name="nexus.analytics.proprietaryRepository.isIQEnabled", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public boolean isIQEnabled() {
        return this.clmConnector.isEnabled() && this.clmConnector.isConfigured();
    }

    @CachedGauge(name="nexus.analytics.proprietaryRepository.enabledPerFormat", absolute=true, timeout=6L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Long> getProprietaryReposPerFormat() {
        return StreamSupport.stream(this.repositoryManager.browse().spliterator(), false).filter(ProprietaryRepositoryAnalytics::isHosted).filter(ProprietaryRepositoryAnalytics::isProprietary).collect(Collectors.toMap(ProprietaryRepositoryAnalytics::getFormat, repository -> 1L, Long::sum));
    }

    private static String getFormat(Repository repository) {
        return repository.getFormat().getValue();
    }

    private static boolean isHosted(Repository repository) {
        return "hosted".equals(repository.getType().getValue());
    }

    private static boolean isProprietary(Repository repository) {
        return (Boolean)repository.getConfiguration().attributes("component").get("proprietaryComponents", Boolean.class, (Object)false);
    }
}

