/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.google.common.base.Preconditions;
import com.sonatype.analytics.internal.metrics.HistoricalLoginInfo;
import com.sonatype.analytics.internal.metrics.HistoricalLoginInfoStore;
import com.sonatype.analytics.internal.metrics.datastore.HistoricalLoginInfoData;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.security.anonymous.AnonymousHelper;

@Named(value="nexus.analytics.loginsCounterHandler")
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@FeatureFlag(name="nexus.circuitb.enabled", enabledByDefault=true)
public class LoginsCounterHandler
extends StateGuardLifecycleSupport
implements Handler {
    private final ConcurrentMap<UserInfo, OffsetDateTime> logins;
    private final HistoricalLoginInfoStore store;
    private final PeriodicJobService periodicJobService;
    private PeriodicJobService.PeriodicJob job;
    private OffsetDateTime lastRun;

    @Inject
    public LoginsCounterHandler(HistoricalLoginInfoStore store, PeriodicJobService periodicJobService) {
        this.store = (HistoricalLoginInfoStore)Preconditions.checkNotNull((Object)store);
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.logins = new ConcurrentHashMap<UserInfo, OffsetDateTime>();
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        try {
            this.saveUserLogin();
        }
        catch (Exception e) {
            this.log.warn("Unable to save login metrics", (Throwable)(this.log.isDebugEnabled() ? e : null));
        }
        return context.proceed();
    }

    private void saveUserLogin() {
        Subject subject = SecurityUtils.getSubject();
        if (AnonymousHelper.isAnonymous((Subject)subject)) {
            return;
        }
        UserInfo userInfo = new UserInfo(subject.getPrincipal().toString(), subject.getPrincipals().getRealmNames().stream().findFirst().orElse(null));
        this.logins.put(userInfo, OffsetDateTime.now());
    }

    protected void doStart() throws Exception {
        OffsetDateTime now = OffsetDateTime.now();
        Collection<HistoricalLoginInfo> loginsForLast30d = this.store.getUniqueLoginsSince(now.minusDays(30L));
        loginsForLast30d.stream().sorted(Comparator.comparing(HistoricalLoginInfo::getLoginDate).reversed()).forEach(loginInfo -> {
            OffsetDateTime offsetDateTime = this.logins.put(new UserInfo(loginInfo.getUsername(), loginInfo.getRealm()), loginInfo.getLoginDate());
        });
        this.lastRun = now;
        this.periodicJobService.startUsing();
        this.job = this.periodicJobService.schedule(this::periodicJob, Duration.ofMinutes(5L));
    }

    public void doStop() throws Exception {
        this.saveNewLogins(this.logins);
        this.job.cancel();
        this.periodicJobService.stopUsing();
    }

    private void periodicJob() {
        OffsetDateTime thisRun = OffsetDateTime.now();
        HashMap<UserInfo, OffsetDateTime> clone = new HashMap<UserInfo, OffsetDateTime>(this.logins);
        clone.entrySet().stream().filter(e -> ((OffsetDateTime)e.getValue()).isBefore(thisRun.minusMonths(1L))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).forEach(this.logins::remove);
        this.saveNewLogins(clone);
        this.lastRun = thisRun;
    }

    private void saveNewLogins(Map<UserInfo, OffsetDateTime> map) {
        List<HistoricalLoginInfo> loginInfoData = map.entrySet().stream().filter(e -> this.lastRun.isBefore((OffsetDateTime)e.getValue())).map(e -> new HistoricalLoginInfoData(((UserInfo)e.getKey()).getUsername(), ((UserInfo)e.getKey()).getRealm(), (OffsetDateTime)e.getValue())).collect(Collectors.toList());
        this.store.save(loginInfoData);
    }

    private static class UserInfo {
        private final String username;
        private final String realm;

        public UserInfo(String username, String realm) {
            this.username = username;
            this.realm = realm;
        }

        public String getUsername() {
            return this.username;
        }

        public String getRealm() {
            return this.realm;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserInfo userInfo = (UserInfo)o;
            return Objects.equals(this.username, userInfo.username) && Objects.equals(this.realm, userInfo.realm);
        }

        public int hashCode() {
            return Objects.hash(this.username, this.realm);
        }
    }
}

