/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal;

import com.sonatype.analytics.internal.evaluator.ContentUsageEvaluatorManager;
import com.sonatype.analytics.internal.evaluator.EvaluatorResult;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.rapture.StateContributor;

@Named
@Singleton
public class ContentUsageLevelStateContributor
implements StateContributor {
    private static final String CONTENT_USAGE_EVALUATION_RESULT = "contentUsageEvaluationResult";
    private final ContentUsageEvaluatorManager contentUsageEvaluatorManager;

    @Inject
    public ContentUsageLevelStateContributor(ContentUsageEvaluatorManager contentUsageEvaluatorManager) {
        this.contentUsageEvaluatorManager = Objects.requireNonNull(contentUsageEvaluatorManager);
    }

    public Map<String, Object> getState() {
        List<EvaluatorResult> evaluatorResults = this.contentUsageEvaluatorManager.getEvaluatorResults();
        return Collections.singletonMap(CONTENT_USAGE_EVALUATION_RESULT, evaluatorResults);
    }
}

